/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

/*
 * NUCLEO-L476RG-example001 - Started on 07/04/2022
 * The goal of this project is to study RPM control of a ESC.
 * Based On: NUCLEO-L476RG-FreeRTOS008 - Started 09/25/2019
 * On the WIN710 PC.
 * This doesn't use FreeRTOS.
 * Uses the Virtual COM port for instrumentation.
 * USART2 is used at 115200-8-N-1.
 * PA2 is TX, PA3 is RX.
 * Had to add C++ Setting use float with printf & scanf.
 * C:\Users\frank\STM32Cube\Repository\STM32Cube_FW_L4_V1.17.2\Drivers\CMSIS\DSP\Include
 * Make sure include path "C/C+ Build Settings, MCU GCC Compiler, Include Paths added for arm_math.h.
 * This has a 10,000 Hz frame time which is not stable.
 *
 * NUCLEO-L476RG-example002 - Started on 07/05/2022
 * The goal of this project is to study RPM control of a ESC.
 * On the WIN710 PC.
 * This uses FreeRTOS with one task.
 * Uses the Virtual COM port for instrumentation.
 * USART2 is used at 115200-8-N-1.
 * PA2 is TX, PA3 is RX.
 * Had to add C++ Setting use float with printf & scanf.
 * C:\Users\frank\STM32Cube\Repository\STM32Cube_FW_L4_V1.17.2\Drivers\CMSIS\DSP\Include
 * Make sure include path "C/C+ Build Settings, MCU GCC Compiler, Include Paths added for arm_math.h.
 * This has a 100 Hz frame time that is stable.
 *
 *  NUCLEO-L476RG-example003 - Started on 07/05/2022
 * The goal of this project is to study RPM control of a ESC.
 * Since example002 with FreeRTOS was stable,
 * the ideal here is to try using a hardware interrupt to get a good 100 Hz system.
 * On the WIN710 PC.
 * This doesn't use FreeRTOS.
 * Uses the Virtual COM port for instrumentation.
 * USART2 is used at 115200-8-N-1.
 * PA2 is TX, PA3 is RX.
 * Had to add C++ Setting use float with printf & scanf.
 * C:\Users\frank\STM32Cube\Repository\STM32Cube_FW_L4_V1.17.2\Drivers\CMSIS\DSP\Include
 * Make sure include path "C/C+ Build Settings, MCU GCC Compiler, Include Paths added for arm_math.h.
 * This has a 100 Hz frame time that is stable.
 *
 * NUCLEO-L476RG-example004 - Started on 07/05/2022
 * Derived from NUCLEO-L476RG-example002.
 * The goal of this project is to study RPM control of a ESC.
 * On the WIN710 PC.
 * This uses FreeRTOS with one task.
 * Uses the Virtual COM port for instrumentation.
 * USART2 is used at 115200-8-N-1.
 * PA2 is TX, PA3 is RX.
 * Had to add C++ Setting use float with printf & scanf.
 * C:\Users\frank\STM32Cube\Repository\STM32Cube_FW_L4_V1.17.2\Drivers\CMSIS\DSP\Include
 * Make sure include path "C/C+ Build Settings, MCU GCC Compiler, Include Paths added for arm_math.h.
 * This has a 400 Hz frame time that is stable.
 *
 * NUCLEO-L476RG-example005 - Started on 07/05/2022
 * Derived from NUCLEO-L476RG-example003.
 * The goal of this project is to study RPM control of a ESC.
 * Since example004 with FreeRTOS was stable,
 * the ideal here is to try using a hardware interrupt to get a good 400 Hz system.
 * On the WIN710 PC.
 * This doesn't use FreeRTOS.
 * Uses the Virtual COM port for instrumentation.
 * USART2 is used at 115200-8-N-1.
 * PA2 is TX, PA3 is RX.
 * Had to add C++ Setting use float with printf & scanf.
 * C:\Users\frank\STM32Cube\Repository\STM32Cube_FW_L4_V1.17.2\Drivers\CMSIS\DSP\Include
 * Make sure include path "C/C+ Build Settings, MCU GCC Compiler, Include Paths added for arm_math.h.
 * This has a 400 Hz frame time that is stable.
 *
 * NUCLEO-L476RG-example006 - Started on 07/05/2022
 * Derived from NUCLEO-L476RG-example005.
 * This is to try to repeat example001 and try for a stable 10,000 Hz frame rate.
 * Try Systick & TIM2 as the "Timebase Source" for SYS.
 * The goal of this project is to study RPM control of a ESC.
 * On the WIN710 PC.
 * This doesn't use FreeRTOS.
 * Uses the Virtual COM port for instrumentation.
 * USART2 is used at 115200-8-N-1.
 * PA2 is TX, PA3 is RX.
 * Had to add C++ Setting use float with printf & scanf.
 * C:\Users\frank\STM32Cube\Repository\STM32Cube_FW_L4_V1.17.2\Drivers\CMSIS\DSP\Include
 * Make sure include path "C/C+ Build Settings, MCU GCC Compiler, Include Paths added for arm_math.h.
 * This has a 10,000 Hz frame time that is stable.
 * It doesn't matter if the SYS "Timebase Source" is "SysTick" or "TIM2".
 * I will leave it at TIM2 for now.
 *
 * NUCLEO-L476RG-example007 - Started on 07/08/2022
 * Derived from NUCLEO-L476RG-example005.
 * Add PWM Control for Motor Driver using TIM4.
 * TIM4_CH1 = PB6, TIM4_CH2 = PB7, TIM4_CH3 = PB8, TIM4_CH4 = PB9.
 * The goal of this project is to study RPM control of a ESC.
 * On the WIN710 PC.
 * This doesn't use FreeRTOS.
 * Uses the Virtual COM port for instrumentation.
 * USART2 is used at 115200-8-N-1.
 * PA2 is TX, PA3 is RX.
 * Had to add C++ Setting use float with printf & scanf.
 * C:\Users\frank\STM32Cube\Repository\STM32Cube_FW_L4_V1.17.2\Drivers\CMSIS\DSP\Include
 * Make sure include path "C/C+ Build Settings, MCU GCC Compiler, Include Paths added for arm_math.h.
 * This has a 400 Hz frame time that is stable.
 * Add Servo Simulator. - TIM15 - PB14.
 * Add ESC Brushless Motor - TIM4.
 * Add RPM Sensor. - TIM1 - PA8.
 * 	a_pwm_fix	rpm
 *	1100		2500
 *	1102		2645
 *	1110		3279
 *	1111		3299
 *	1120		3850
 *	1130		4423
 *	1140		4900
 *	1150		5431
 *	1200		7035
 *	1300		8645
 *	1400		9604
 *	1500		9823
 *	1600		10029
 *	1700		10268
 *	1800		10492
 *	1900		10467
 *
 * NUCLEO-L476RG-example008 - Started on 07/10/2022
 * Try to get better resolution for ESC command.
 * Derived from NUCLEO-L476RG-example007.
 * Add PWM Control for Motor Driver using TIM4.
 * TIM4_CH1 = PB6, TIM4_CH2 = PB7, TIM4_CH3 = PB8, TIM4_CH4 = PB9.
 * The goal of this project is to study RPM control of a ESC.
 * On the WIN710 PC.
 * This doesn't use FreeRTOS.
 * Uses the Virtual COM port for instrumentation.
 * USART2 is used at 115200-8-N-1.
 * PA2 is TX, PA3 is RX.
 * Had to add C++ Setting use float with printf & scanf.
 * C:\Users\frank\STM32Cube\Repository\STM32Cube_FW_L4_V1.17.2\Drivers\CMSIS\DSP\Include
 * Make sure include path "C/C+ Build Settings, MCU GCC Compiler, Include Paths added for arm_math.h.
 * This has a 400 Hz frame time that is stable.
 * Add Servo Simulator. - TIM15 - PB14.
 * Add ESC Brushless Motor - TIM4.
 * Add RPM Sensor. - TIM1 - PA8.
 * 	a_pwm_fix	rpm
 * 	2200		2722
 * 	2250		4253
 * 	2300		5780
 * 	2350		6717
 * 	2400		7461
 * 	2450		8045
 * 	2500		8573
 * 	2550		8891
 * 	2600		9294
 * 	2650		9375
 * 	2700		9801
 * 	2750		9899
 * 	2800		10052
 * 	2850		10171
 * 	2900		10219
 *
 * NUCLEO-L476RG-example009 - Started on 07/11/2022
 * Add a RPM Control Loop.
 * Derived from NUCLEO-L476RG-example008.
 * Add PWM Control for Motor Driver using TIM4.
 * TIM4_CH1 = PB6, TIM4_CH2 = PB7, TIM4_CH3 = PB8, TIM4_CH4 = PB9.
 * The goal of this project is to study RPM control of a ESC.
 * On the WIN710 PC.
 * This doesn't use FreeRTOS.
 * Uses the Virtual COM port for instrumentation.
 * USART2 is used at 115200-8-N-1.
 * PA2 is TX, PA3 is RX.
 * Had to add C++ Setting use float with printf & scanf.
 * C:\Users\frank\STM32Cube\Repository\STM32Cube_FW_L4_V1.17.2\Drivers\CMSIS\DSP\Include
 * Make sure include path "C/C+ Build Settings, MCU GCC Compiler, Include Paths added for arm_math.h.
 * This has a 400 Hz frame time that is stable.
 * Add Servo Simulator. - TIM15 - PB14.
 * Add ESC Brushless Motor - TIM4.
 * Add RPM Sensor. - TIM1 - PA8.
 *
 * NUCLEO-L476RG-example010 - Started on 07/12/2022
 * Add a RPM Control Loop. - Refined example009 with integral control.
 * Derived from NUCLEO-L476RG-example009
 * Add PWM Control for Motor Driver using TIM4.
 * TIM4_CH1 = PB6, TIM4_CH2 = PB7, TIM4_CH3 = PB8, TIM4_CH4 = PB9.
 * The goal of this project is to study RPM control of a ESC.
 * On the WIN710 PC.
 * This doesn't use FreeRTOS.
 * Uses the Virtual COM port for instrumentation.
 * USART2 is used at 115200-8-N-1.
 * PA2 is TX, PA3 is RX.
 * Had to add C++ Setting use float with printf & scanf.
 * C:\Users\frank\STM32Cube\Repository\STM32Cube_FW_L4_V1.17.2\Drivers\CMSIS\DSP\Include
 * Make sure include path "C/C+ Build Settings, MCU GCC Compiler, Include Paths added for arm_math.h.
 * This has a 400 Hz frame time that is stable.
 * Add Servo Simulator. - TIM15 - PB14.
 * Add ESC Brushless Motor - TIM4.
 * Add RPM Sensor. - TIM1 - PA8.
 */

#include <stdio.h>
#include <math.h>
#define ARM_MATH_CM4
#include "arm_math.h"
#include <string.h>

/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
ADC_HandleTypeDef hadc1;
DMA_HandleTypeDef hdma_adc1;

DAC_HandleTypeDef hdac1;

TIM_HandleTypeDef htim1;
TIM_HandleTypeDef htim3;
TIM_HandleTypeDef htim4;
TIM_HandleTypeDef htim15;

UART_HandleTypeDef huart2;

/* USER CODE BEGIN PV */

__IO uint16_t interrupt_flag = 1; /* This is used to determine if the frame should be executed. */

/* Parameters for USART2 Instrumentation. */
char cbuffer[500];
HAL_StatusTypeDef HAL_Status;
#define __no_init    __attribute__((section (".noinit")))
__no_init float32_t i_fbuffer01[300]; // Instrumentation floating buffer01.
__no_init float32_t i_fbuffer02[300]; // Instrumentation floating buffer02.
__no_init float32_t i_fbuffer03[300]; // Instrumentation floating buffer03.
__no_init uint32_t i_ibuffer01[300]; // Instrumentation integer buffer01.
uint32_t i_index1 = 0, i_index2 = 200, i_index3 = 0;
uint16_t user_switch_pressed = 0, user_switch = 0; // The User Switch is a PC13.


/* Frame Counter and Time. */
uint32_t frame_counter = 0; /* This is the main frame_counter. */
float32_t ts = 1.0/400.0; /* This is the update time for a 400 Hz system. */
float32_t atime = 0.0; /* This is the time in seconds. */

/* ADCs & DAC. */
uint32_t ADC_Raw[6] = {0,0,0,0,0,0};
uint16_t ADC_Signal_Raw1 = 0, ADC_Signal_Raw2 = 0, ADC_Signal_Raw3 = 0;
uint16_t ADC_Signal_Raw4 = 0, ADC_Signal_Raw5 = 0, ADC_Signal_Raw6 = 0;
float32_t ADC_Signal_1 = 0.0, ADC_Signal_2 = 0.0, ADC_Signal_3 = 0.0;
float32_t ADC_Signal_4 = 0.0, ADC_Signal_5 = 0.0, ADC_Signal_6 = 0.0;

uint32_t DAC_Raw1 = 1000;
float32_t DAC_Signal_1 = 0.0;
uint32_t DAC_Raw2 = 1000;
float32_t DAC_Signal_2 = 0.0;

float32_t atemp = 0.0;

/* To run the motor set a_pwm_fix to 2200. */
/* To stop the motor set a_pwm_fix to 2000. */
/* PB6 = TIM4_CH1 */
uint16_t a_pwm_fix=2000, b_pwm_fix = 2000, c_pwm_fix=2000, d_pwm_fix=2000;

/* TIM15_CH1 = PB14 - Read Knob of Servo Simulator. */
uint32_t ss_pulse_capture1 = 0;
uint32_t ss_pulse_capture2 = 0;
uint32_t ss_pulse_captured = 0;
float32_t ss_pulse_sec = 0.0;
uint16_t ss_valid = 0;

/* TIM1_CH1 = PA8 - Read RPM Sensor Pulse. */
uint32_t rpm_pulse_capture1 = 0;
uint32_t rpm_pulse_capture2 = 0;
uint32_t rpm_pulse_captured = 0;
float32_t rpm_pulse_sec = 0.0; // Sec.
float32_t rpm = 0.0; // RPM
uint16_t rpm_valid = 0;

/* Parameters for the rpm control servo.  - The motor starts to turn at ESC-counts=2200.*/
/* The motor is idle at 2000 counts. */
float32_t rpm_cmd = 0.0;
float32_t rpm_error = 0.0;
float32_t rpm_error_i = 0.0, rpm_error_1 = 0.0, rpm_error_i_1 = 0.0; // Parameters for the integrator.
float32_t Krpm_proportional = 0.2; // This is the proportion gain. (ESC-counts/rpm).
/* This is the integral gain. (ESC-counts-sec/rpm). */
float32_t Krpm_integral = 1.0, rpm_integral_max = 2000.0, rpm_integral_min = -2000.0;
float32_t rpm_bias = 2000.0; // This is the bias. (ESC-counts).
float32_t rpm_min = 2800.0, rpm_max = 10000.0; // This is the minimal and maximum rpm.
uint16_t ESC_count_max = 2900, ESC_count_min = 2000; // This is the max and min ESC-counts.
uint16_t ESC_count_idle = 2000; // This is the idle ESC-counts.
/* rpm LPF. */
float32_t rpm_xn_1 = 0.0, rpm_yn = 0.0, rpm_yn_1 = 0.0;
float32_t rpm_tau = 0.005, rpm_filt = 0.0;

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
static void MX_GPIO_Init(void);
static void MX_DMA_Init(void);
static void MX_USART2_UART_Init(void);
static void MX_ADC1_Init(void);
static void MX_DAC1_Init(void);
static void MX_TIM1_Init(void);
static void MX_TIM3_Init(void);
static void MX_TIM4_Init(void);
static void MX_TIM15_Init(void);
/* USER CODE BEGIN PFP */

float32_t LAG(float32_t xn, float32_t ts, float32_t tau, float32_t *xn_1, float32_t *yn_1);
float32_t INTEGRATE(float32_t xn, float32_t ts, float32_t upper, float32_t lower, float32_t *xn_1, float32_t *yn_1);
float32_t HIPASS(float32_t xn, float32_t ts, float32_t tau, float32_t *xn_1, float32_t *yn_1);

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
  /* USER CODE BEGIN 1 */

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_DMA_Init();
  MX_USART2_UART_Init();
  MX_ADC1_Init();
  MX_DAC1_Init();
  MX_TIM1_Init();
  MX_TIM3_Init();
  MX_TIM4_Init();
  MX_TIM15_Init();
  /* USER CODE BEGIN 2 */

  /* For Instrumentation Buffers. */

  char astring1[] = "Welcome to example008!!!!";
  sprintf(cbuffer, "\f\r\n%s", astring1);
  HAL_Status = HAL_UART_Transmit(&huart2, (uint8_t *)cbuffer, strlen(cbuffer), 1000);

  char astring2[] = "begin";
  sprintf(cbuffer, "\r\n%s", astring2);
  HAL_Status = HAL_UART_Transmit(&huart2, (uint8_t *)cbuffer, strlen(cbuffer), 1000);


  for (i_index3 = 0; i_index3 < i_index2; i_index3++)
  {
	  sprintf(cbuffer, "\r\n%li %f %f %f", i_ibuffer01[i_index3], i_fbuffer01[i_index3], i_fbuffer02[i_index3], i_fbuffer03[i_index3]);
   	  HAL_Status = HAL_UART_Transmit(&huart2, (uint8_t *)cbuffer, strlen(cbuffer), 1000);
  }

  char astring3[] = "end";
  sprintf(cbuffer, "\r\n%s", astring3);
  HAL_Status = HAL_UART_Transmit(&huart2, (uint8_t *)cbuffer, strlen(cbuffer), 1000);


  /* Start the ADCs. */
  HAL_ADC_Start_DMA(&hadc1, (uint32_t *)ADC_Raw, 6);

  /* Start the DAC. */
  HAL_DAC_Start(&hdac1, DAC_CHANNEL_1);
  HAL_DAC_Start(&hdac1, DAC_CHANNEL_2);

  /* Start the main timer. */
  HAL_TIM_OC_Start_IT(&htim3, TIM_CHANNEL_1);

  /* Start the PWM. */
  HAL_TIM_PWM_Start(&htim4, TIM_CHANNEL_1); // PB6 = TIM4_CH1
  HAL_TIM_PWM_Start(&htim4, TIM_CHANNEL_2); // PB7 = TIM4_CH2
  HAL_TIM_PWM_Start(&htim4, TIM_CHANNEL_3); // PB8 = TIM4_CH3
  HAL_TIM_PWM_Start(&htim4, TIM_CHANNEL_4); // PB9 = TIM4_CH4

  /* Start the Input Capture Timer to read the servo simulator knob at PB14. */
  HAL_TIM_IC_Start(&htim15, TIM_CHANNEL_1);
  HAL_TIM_IC_Start(&htim15, TIM_CHANNEL_2);

  /* Start the Input Capture Timer to read the rpm at TIM1_CH1 = PA8. */
  HAL_TIM_IC_Start(&htim1, TIM_CHANNEL_1);
  HAL_TIM_IC_Start(&htim1, TIM_CHANNEL_2);

  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
  while (1)
  {
		if(interrupt_flag)
		{
		  HAL_GPIO_WritePin(GPIOA, GPIO_PIN_6, GPIO_PIN_SET);

		  frame_counter++;
		  atime = ts * frame_counter;

		  /* Read ADCs. */
		  ADC_Signal_Raw1 = (uint16_t)ADC_Raw[0]; // ADC1_IN1 = PC0
		  ADC_Signal_Raw2 = (uint16_t)ADC_Raw[1]; // ADC1_IN2 = PC1
		  ADC_Signal_Raw3 = (uint16_t)ADC_Raw[2]; // ADC1_IN3 = PC2
		  ADC_Signal_Raw4 = (uint16_t)ADC_Raw[3]; // ADC1_IN4 = PC3
		  ADC_Signal_Raw5 = (uint16_t)ADC_Raw[4]; // ADC1_IN5 = PA0
		  ADC_Signal_Raw6 = (uint16_t)ADC_Raw[5]; // ADC1_IN6 = PA1
		  ADC_Signal_1 = (float32_t)ADC_Signal_Raw1;
		  ADC_Signal_2 = (float32_t)ADC_Signal_Raw2;
		  ADC_Signal_3 = (float32_t)ADC_Signal_Raw3;
		  ADC_Signal_4 = (float32_t)ADC_Signal_Raw4;
		  ADC_Signal_5 = (float32_t)ADC_Signal_Raw5;
		  ADC_Signal_6 = (float32_t)ADC_Signal_Raw6;


		  /* This is a do nothing delay loop used to take up some time. */
		  for (uint32_t i = 0; i < 10; i++)
		  	  {
			  	  atemp = (float32_t)i;
		  	  }

		  /* Store Data on Blue User Switch Press. */
		  if(user_switch)
		  {
			  i_ibuffer01[i_index1] = frame_counter;
			  i_fbuffer01[i_index1] = atime;
			  i_fbuffer02[i_index1] = ADC_Signal_1;
			  i_fbuffer03[i_index1] = ADC_Signal_2;
			  i_index1++;
			  if(i_index1 > i_index2)
			  {
				  user_switch = 0;
				  i_index1 = 0;
			  }
		  }

		  /* Check the user_switch if not pressed. This will latch the users switch to take data. */
		  /* After taking the data press reset to dump the data from the UART. */
		  if(HAL_GPIO_ReadPin(GPIOC, GPIO_PIN_13))
		  {
			  user_switch_pressed = 0;
		  }
		  else
		  {
			  user_switch_pressed = 1;
			  user_switch = 1;
		  }

		  /* Write DAC - Wrap ADC Back. */
		  DAC_Raw1 = (uint32_t)ADC_Signal_1; // DAC1_OUT1 = PA4
		  HAL_DAC_SetValue(&hdac1, DAC_CHANNEL_1, DAC_ALIGN_12B_R, DAC_Raw1); // PA4

		  DAC_Raw2 = (uint32_t)ADC_Signal_2; // DAC1_OUT2 = PA5
		  HAL_DAC_SetValue(&hdac1, DAC_CHANNEL_2, DAC_ALIGN_12B_R, DAC_Raw2); // PA5

		  /* Read the servo simulator. TIM15_CH1 = PB14.*/
		  /* Set the Prescaler to 79 provides 1x10-6 second per bit. */
		  /* Has a normal range of 1ms to 2ms. Anything greater than 2.5ms will hold the last good value */
		  ss_pulse_capture1 = HAL_TIM_ReadCapturedValue(&htim15, TIM_CHANNEL_1);
		  ss_pulse_capture2 = HAL_TIM_ReadCapturedValue(&htim15, TIM_CHANNEL_2);
		  ss_pulse_captured = ss_pulse_capture2 - ss_pulse_capture1;
		  if (ss_pulse_captured <= 2500)
		  {
			  ss_pulse_sec = 80.0/80000000.0*(float32_t)ss_pulse_captured;
			  ss_valid = 1;
		  }
		  else
		  {
			  ss_valid = 0;
		  }

		  /* Read the RPM sensor. TIM1_CH1 = PA8.*/
		  /* Set the Prescaler to 79 provides 1x10-6 second per bit. */
		  /* The pulses are smaller the faster the motor turns. */
		  /* Test point at 1100 command = 2567 RPM at 1.68 ms = 1680 counts. 4.31256 RPM-count */
		  /* Lets say the valid range is 100 to 11,000 RPM. */
		  /* This has a range of 0.0431256 to 0.000392051 sec. */
		  /* This has a range of 392 to 43,125 counts. */
		  rpm_pulse_capture1 = HAL_TIM_ReadCapturedValue(&htim1, TIM_CHANNEL_1);
		  rpm_pulse_capture2 = HAL_TIM_ReadCapturedValue(&htim1, TIM_CHANNEL_2);
		  rpm_pulse_captured = rpm_pulse_capture2 - rpm_pulse_capture1;
		  if (rpm_pulse_captured >= 392 && rpm_pulse_captured <= 43125)
		  {
			  rpm_pulse_sec = 80.0/80000000.0*(float32_t)rpm_pulse_captured;
			  rpm = 4.31256/rpm_pulse_sec;
			  rpm_valid = 1;
		  }
		  else
		  {
			  rpm_valid = 0;
		  }

		  /* RPM Control Servo Proportional plus integral control loop. */

		  /* rpm Low-Pass Filter */
		  rpm_yn = LAG(rpm, ts, rpm_tau, &rpm_xn_1, &rpm_yn_1);
		  rpm_filt = rpm_yn;

		  if(rpm_cmd < rpm_min) rpm_filt = 0.0; // Set the rpm to zero if the command is less than the minimal.
		  if(rpm_cmd > rpm_max) rpm_cmd = rpm_max; // Limit the command to the maximum.

		  rpm_error = rpm_cmd - rpm_filt; // This is the RPM error.
		  /* This is the integral part. */
          rpm_error_i = INTEGRATE(rpm_error, ts, rpm_integral_max, rpm_integral_min, &rpm_error_1, &rpm_error_i_1);


		  a_pwm_fix = (uint16_t)(Krpm_proportional*rpm_error + Krpm_integral*rpm_error_i + rpm_bias); // This is the CLAW.

		  if(a_pwm_fix > ESC_count_max) a_pwm_fix = ESC_count_max;
		  if(a_pwm_fix < ESC_count_min) a_pwm_fix = ESC_count_idle;

		  if(rpm_cmd < rpm_min) a_pwm_fix = ESC_count_idle;

		  /* PWM - Prescaler set to 39 at 80MHz. 2000 = 1ms. */
		  /* The Counter Period is set to 4999 which will provide at 400 Hz update rate. */
		  __HAL_TIM_SET_COMPARE(&htim4, TIM_CHANNEL_1, a_pwm_fix); // PB6 = TIM4_CH1
		  __HAL_TIM_SET_COMPARE(&htim4, TIM_CHANNEL_2, b_pwm_fix); // PB7 = TIM4_CH2
		  __HAL_TIM_SET_COMPARE(&htim4, TIM_CHANNEL_3, c_pwm_fix); // PB8 = TIM4_CH3
		  __HAL_TIM_SET_COMPARE(&htim4, TIM_CHANNEL_4, d_pwm_fix); // PB9 = TIM4_CH4

		  interrupt_flag = 0;

		  HAL_GPIO_WritePin(GPIOA, GPIO_PIN_6, GPIO_PIN_RESET);
	  }

    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */
  }
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Configure the main internal regulator output voltage
  */
  if (HAL_PWREx_ControlVoltageScaling(PWR_REGULATOR_VOLTAGE_SCALE1) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.HSICalibrationValue = RCC_HSICALIBRATION_DEFAULT;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSI;
  RCC_OscInitStruct.PLL.PLLM = 1;
  RCC_OscInitStruct.PLL.PLLN = 10;
  RCC_OscInitStruct.PLL.PLLP = RCC_PLLP_DIV7;
  RCC_OscInitStruct.PLL.PLLQ = RCC_PLLQ_DIV2;
  RCC_OscInitStruct.PLL.PLLR = RCC_PLLR_DIV2;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_4) != HAL_OK)
  {
    Error_Handler();
  }
}

/**
  * @brief ADC1 Initialization Function
  * @param None
  * @retval None
  */
static void MX_ADC1_Init(void)
{

  /* USER CODE BEGIN ADC1_Init 0 */

  /* USER CODE END ADC1_Init 0 */

  ADC_MultiModeTypeDef multimode = {0};
  ADC_ChannelConfTypeDef sConfig = {0};

  /* USER CODE BEGIN ADC1_Init 1 */

  /* USER CODE END ADC1_Init 1 */

  /** Common config
  */
  hadc1.Instance = ADC1;
  hadc1.Init.ClockPrescaler = ADC_CLOCK_ASYNC_DIV1;
  hadc1.Init.Resolution = ADC_RESOLUTION_12B;
  hadc1.Init.DataAlign = ADC_DATAALIGN_RIGHT;
  hadc1.Init.ScanConvMode = ADC_SCAN_ENABLE;
  hadc1.Init.EOCSelection = ADC_EOC_SEQ_CONV;
  hadc1.Init.LowPowerAutoWait = DISABLE;
  hadc1.Init.ContinuousConvMode = DISABLE;
  hadc1.Init.NbrOfConversion = 6;
  hadc1.Init.DiscontinuousConvMode = DISABLE;
  hadc1.Init.ExternalTrigConv = ADC_EXTERNALTRIG_T3_TRGO;
  hadc1.Init.ExternalTrigConvEdge = ADC_EXTERNALTRIGCONVEDGE_RISINGFALLING;
  hadc1.Init.DMAContinuousRequests = ENABLE;
  hadc1.Init.Overrun = ADC_OVR_DATA_PRESERVED;
  hadc1.Init.OversamplingMode = DISABLE;
  if (HAL_ADC_Init(&hadc1) != HAL_OK)
  {
    Error_Handler();
  }

  /** Configure the ADC multi-mode
  */
  multimode.Mode = ADC_MODE_INDEPENDENT;
  if (HAL_ADCEx_MultiModeConfigChannel(&hadc1, &multimode) != HAL_OK)
  {
    Error_Handler();
  }

  /** Configure Regular Channel
  */
  sConfig.Channel = ADC_CHANNEL_1;
  sConfig.Rank = ADC_REGULAR_RANK_1;
  sConfig.SamplingTime = ADC_SAMPLETIME_2CYCLES_5;
  sConfig.SingleDiff = ADC_SINGLE_ENDED;
  sConfig.OffsetNumber = ADC_OFFSET_NONE;
  sConfig.Offset = 0;
  if (HAL_ADC_ConfigChannel(&hadc1, &sConfig) != HAL_OK)
  {
    Error_Handler();
  }

  /** Configure Regular Channel
  */
  sConfig.Rank = ADC_REGULAR_RANK_2;
  if (HAL_ADC_ConfigChannel(&hadc1, &sConfig) != HAL_OK)
  {
    Error_Handler();
  }

  /** Configure Regular Channel
  */
  sConfig.Rank = ADC_REGULAR_RANK_3;
  if (HAL_ADC_ConfigChannel(&hadc1, &sConfig) != HAL_OK)
  {
    Error_Handler();
  }

  /** Configure Regular Channel
  */
  sConfig.Rank = ADC_REGULAR_RANK_4;
  if (HAL_ADC_ConfigChannel(&hadc1, &sConfig) != HAL_OK)
  {
    Error_Handler();
  }

  /** Configure Regular Channel
  */
  sConfig.Rank = ADC_REGULAR_RANK_5;
  if (HAL_ADC_ConfigChannel(&hadc1, &sConfig) != HAL_OK)
  {
    Error_Handler();
  }

  /** Configure Regular Channel
  */
  sConfig.Rank = ADC_REGULAR_RANK_6;
  if (HAL_ADC_ConfigChannel(&hadc1, &sConfig) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN ADC1_Init 2 */

  /* USER CODE END ADC1_Init 2 */

}

/**
  * @brief DAC1 Initialization Function
  * @param None
  * @retval None
  */
static void MX_DAC1_Init(void)
{

  /* USER CODE BEGIN DAC1_Init 0 */

  /* USER CODE END DAC1_Init 0 */

  DAC_ChannelConfTypeDef sConfig = {0};

  /* USER CODE BEGIN DAC1_Init 1 */

  /* USER CODE END DAC1_Init 1 */

  /** DAC Initialization
  */
  hdac1.Instance = DAC1;
  if (HAL_DAC_Init(&hdac1) != HAL_OK)
  {
    Error_Handler();
  }

  /** DAC channel OUT1 config
  */
  sConfig.DAC_SampleAndHold = DAC_SAMPLEANDHOLD_DISABLE;
  sConfig.DAC_Trigger = DAC_TRIGGER_NONE;
  sConfig.DAC_OutputBuffer = DAC_OUTPUTBUFFER_ENABLE;
  sConfig.DAC_ConnectOnChipPeripheral = DAC_CHIPCONNECT_DISABLE;
  sConfig.DAC_UserTrimming = DAC_TRIMMING_FACTORY;
  if (HAL_DAC_ConfigChannel(&hdac1, &sConfig, DAC_CHANNEL_1) != HAL_OK)
  {
    Error_Handler();
  }

  /** DAC channel OUT2 config
  */
  if (HAL_DAC_ConfigChannel(&hdac1, &sConfig, DAC_CHANNEL_2) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN DAC1_Init 2 */

  /* USER CODE END DAC1_Init 2 */

}

/**
  * @brief TIM1 Initialization Function
  * @param None
  * @retval None
  */
static void MX_TIM1_Init(void)
{

  /* USER CODE BEGIN TIM1_Init 0 */

  /* USER CODE END TIM1_Init 0 */

  TIM_ClockConfigTypeDef sClockSourceConfig = {0};
  TIM_MasterConfigTypeDef sMasterConfig = {0};
  TIM_IC_InitTypeDef sConfigIC = {0};

  /* USER CODE BEGIN TIM1_Init 1 */

  /* USER CODE END TIM1_Init 1 */
  htim1.Instance = TIM1;
  htim1.Init.Prescaler = 79;
  htim1.Init.CounterMode = TIM_COUNTERMODE_UP;
  htim1.Init.Period = 65535;
  htim1.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
  htim1.Init.RepetitionCounter = 0;
  htim1.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_DISABLE;
  if (HAL_TIM_Base_Init(&htim1) != HAL_OK)
  {
    Error_Handler();
  }
  sClockSourceConfig.ClockSource = TIM_CLOCKSOURCE_INTERNAL;
  if (HAL_TIM_ConfigClockSource(&htim1, &sClockSourceConfig) != HAL_OK)
  {
    Error_Handler();
  }
  if (HAL_TIM_IC_Init(&htim1) != HAL_OK)
  {
    Error_Handler();
  }
  sMasterConfig.MasterOutputTrigger = TIM_TRGO_RESET;
  sMasterConfig.MasterOutputTrigger2 = TIM_TRGO2_RESET;
  sMasterConfig.MasterSlaveMode = TIM_MASTERSLAVEMODE_DISABLE;
  if (HAL_TIMEx_MasterConfigSynchronization(&htim1, &sMasterConfig) != HAL_OK)
  {
    Error_Handler();
  }
  sConfigIC.ICPolarity = TIM_INPUTCHANNELPOLARITY_RISING;
  sConfigIC.ICSelection = TIM_ICSELECTION_DIRECTTI;
  sConfigIC.ICPrescaler = TIM_ICPSC_DIV1;
  sConfigIC.ICFilter = 0;
  if (HAL_TIM_IC_ConfigChannel(&htim1, &sConfigIC, TIM_CHANNEL_1) != HAL_OK)
  {
    Error_Handler();
  }
  sConfigIC.ICPolarity = TIM_INPUTCHANNELPOLARITY_FALLING;
  sConfigIC.ICSelection = TIM_ICSELECTION_INDIRECTTI;
  if (HAL_TIM_IC_ConfigChannel(&htim1, &sConfigIC, TIM_CHANNEL_2) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN TIM1_Init 2 */

  /* USER CODE END TIM1_Init 2 */

}

/**
  * @brief TIM3 Initialization Function
  * @param None
  * @retval None
  */
static void MX_TIM3_Init(void)
{

  /* USER CODE BEGIN TIM3_Init 0 */

  /* USER CODE END TIM3_Init 0 */

  TIM_ClockConfigTypeDef sClockSourceConfig = {0};
  TIM_MasterConfigTypeDef sMasterConfig = {0};
  TIM_OC_InitTypeDef sConfigOC = {0};

  /* USER CODE BEGIN TIM3_Init 1 */

  /* USER CODE END TIM3_Init 1 */
  htim3.Instance = TIM3;
  htim3.Init.Prescaler = 49;
  htim3.Init.CounterMode = TIM_COUNTERMODE_UP;
  htim3.Init.Period = 3999;
  htim3.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
  htim3.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_DISABLE;
  if (HAL_TIM_Base_Init(&htim3) != HAL_OK)
  {
    Error_Handler();
  }
  sClockSourceConfig.ClockSource = TIM_CLOCKSOURCE_INTERNAL;
  if (HAL_TIM_ConfigClockSource(&htim3, &sClockSourceConfig) != HAL_OK)
  {
    Error_Handler();
  }
  if (HAL_TIM_OC_Init(&htim3) != HAL_OK)
  {
    Error_Handler();
  }
  sMasterConfig.MasterOutputTrigger = TIM_TRGO_OC1REF;
  sMasterConfig.MasterSlaveMode = TIM_MASTERSLAVEMODE_DISABLE;
  if (HAL_TIMEx_MasterConfigSynchronization(&htim3, &sMasterConfig) != HAL_OK)
  {
    Error_Handler();
  }
  sConfigOC.OCMode = TIM_OCMODE_TOGGLE;
  sConfigOC.Pulse = 0;
  sConfigOC.OCPolarity = TIM_OCPOLARITY_HIGH;
  sConfigOC.OCFastMode = TIM_OCFAST_DISABLE;
  if (HAL_TIM_OC_ConfigChannel(&htim3, &sConfigOC, TIM_CHANNEL_1) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN TIM3_Init 2 */

  /* USER CODE END TIM3_Init 2 */

}

/**
  * @brief TIM4 Initialization Function
  * @param None
  * @retval None
  */
static void MX_TIM4_Init(void)
{

  /* USER CODE BEGIN TIM4_Init 0 */

  /* USER CODE END TIM4_Init 0 */

  TIM_ClockConfigTypeDef sClockSourceConfig = {0};
  TIM_MasterConfigTypeDef sMasterConfig = {0};
  TIM_OC_InitTypeDef sConfigOC = {0};

  /* USER CODE BEGIN TIM4_Init 1 */

  /* USER CODE END TIM4_Init 1 */
  htim4.Instance = TIM4;
  htim4.Init.Prescaler = 39;
  htim4.Init.CounterMode = TIM_COUNTERMODE_UP;
  htim4.Init.Period = 4999;
  htim4.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
  htim4.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_DISABLE;
  if (HAL_TIM_Base_Init(&htim4) != HAL_OK)
  {
    Error_Handler();
  }
  sClockSourceConfig.ClockSource = TIM_CLOCKSOURCE_INTERNAL;
  if (HAL_TIM_ConfigClockSource(&htim4, &sClockSourceConfig) != HAL_OK)
  {
    Error_Handler();
  }
  if (HAL_TIM_PWM_Init(&htim4) != HAL_OK)
  {
    Error_Handler();
  }
  sMasterConfig.MasterOutputTrigger = TIM_TRGO_RESET;
  sMasterConfig.MasterSlaveMode = TIM_MASTERSLAVEMODE_DISABLE;
  if (HAL_TIMEx_MasterConfigSynchronization(&htim4, &sMasterConfig) != HAL_OK)
  {
    Error_Handler();
  }
  sConfigOC.OCMode = TIM_OCMODE_PWM1;
  sConfigOC.Pulse = 0;
  sConfigOC.OCPolarity = TIM_OCPOLARITY_HIGH;
  sConfigOC.OCFastMode = TIM_OCFAST_DISABLE;
  if (HAL_TIM_PWM_ConfigChannel(&htim4, &sConfigOC, TIM_CHANNEL_1) != HAL_OK)
  {
    Error_Handler();
  }
  if (HAL_TIM_PWM_ConfigChannel(&htim4, &sConfigOC, TIM_CHANNEL_2) != HAL_OK)
  {
    Error_Handler();
  }
  if (HAL_TIM_PWM_ConfigChannel(&htim4, &sConfigOC, TIM_CHANNEL_3) != HAL_OK)
  {
    Error_Handler();
  }
  if (HAL_TIM_PWM_ConfigChannel(&htim4, &sConfigOC, TIM_CHANNEL_4) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN TIM4_Init 2 */

  /* USER CODE END TIM4_Init 2 */
  HAL_TIM_MspPostInit(&htim4);

}

/**
  * @brief TIM15 Initialization Function
  * @param None
  * @retval None
  */
static void MX_TIM15_Init(void)
{

  /* USER CODE BEGIN TIM15_Init 0 */

  /* USER CODE END TIM15_Init 0 */

  TIM_ClockConfigTypeDef sClockSourceConfig = {0};
  TIM_MasterConfigTypeDef sMasterConfig = {0};
  TIM_IC_InitTypeDef sConfigIC = {0};

  /* USER CODE BEGIN TIM15_Init 1 */

  /* USER CODE END TIM15_Init 1 */
  htim15.Instance = TIM15;
  htim15.Init.Prescaler = 79;
  htim15.Init.CounterMode = TIM_COUNTERMODE_UP;
  htim15.Init.Period = 65535;
  htim15.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
  htim15.Init.RepetitionCounter = 0;
  htim15.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_DISABLE;
  if (HAL_TIM_Base_Init(&htim15) != HAL_OK)
  {
    Error_Handler();
  }
  sClockSourceConfig.ClockSource = TIM_CLOCKSOURCE_INTERNAL;
  if (HAL_TIM_ConfigClockSource(&htim15, &sClockSourceConfig) != HAL_OK)
  {
    Error_Handler();
  }
  if (HAL_TIM_IC_Init(&htim15) != HAL_OK)
  {
    Error_Handler();
  }
  sMasterConfig.MasterOutputTrigger = TIM_TRGO_RESET;
  sMasterConfig.MasterSlaveMode = TIM_MASTERSLAVEMODE_DISABLE;
  if (HAL_TIMEx_MasterConfigSynchronization(&htim15, &sMasterConfig) != HAL_OK)
  {
    Error_Handler();
  }
  sConfigIC.ICPolarity = TIM_INPUTCHANNELPOLARITY_RISING;
  sConfigIC.ICSelection = TIM_ICSELECTION_DIRECTTI;
  sConfigIC.ICPrescaler = TIM_ICPSC_DIV1;
  sConfigIC.ICFilter = 0;
  if (HAL_TIM_IC_ConfigChannel(&htim15, &sConfigIC, TIM_CHANNEL_1) != HAL_OK)
  {
    Error_Handler();
  }
  sConfigIC.ICPolarity = TIM_INPUTCHANNELPOLARITY_FALLING;
  sConfigIC.ICSelection = TIM_ICSELECTION_INDIRECTTI;
  if (HAL_TIM_IC_ConfigChannel(&htim15, &sConfigIC, TIM_CHANNEL_2) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN TIM15_Init 2 */

  /* USER CODE END TIM15_Init 2 */

}

/**
  * @brief USART2 Initialization Function
  * @param None
  * @retval None
  */
static void MX_USART2_UART_Init(void)
{

  /* USER CODE BEGIN USART2_Init 0 */

  /* USER CODE END USART2_Init 0 */

  /* USER CODE BEGIN USART2_Init 1 */

  /* USER CODE END USART2_Init 1 */
  huart2.Instance = USART2;
  huart2.Init.BaudRate = 115200;
  huart2.Init.WordLength = UART_WORDLENGTH_8B;
  huart2.Init.StopBits = UART_STOPBITS_1;
  huart2.Init.Parity = UART_PARITY_NONE;
  huart2.Init.Mode = UART_MODE_TX_RX;
  huart2.Init.HwFlowCtl = UART_HWCONTROL_NONE;
  huart2.Init.OverSampling = UART_OVERSAMPLING_16;
  huart2.Init.OneBitSampling = UART_ONE_BIT_SAMPLE_DISABLE;
  huart2.AdvancedInit.AdvFeatureInit = UART_ADVFEATURE_NO_INIT;
  if (HAL_UART_Init(&huart2) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN USART2_Init 2 */

  /* USER CODE END USART2_Init 2 */

}

/**
  * Enable DMA controller clock
  */
static void MX_DMA_Init(void)
{

  /* DMA controller clock enable */
  __HAL_RCC_DMA1_CLK_ENABLE();

  /* DMA interrupt init */
  /* DMA1_Channel1_IRQn interrupt configuration */
  HAL_NVIC_SetPriority(DMA1_Channel1_IRQn, 0, 0);
  HAL_NVIC_EnableIRQ(DMA1_Channel1_IRQn);

}

/**
  * @brief GPIO Initialization Function
  * @param None
  * @retval None
  */
static void MX_GPIO_Init(void)
{
  GPIO_InitTypeDef GPIO_InitStruct = {0};

  /* GPIO Ports Clock Enable */
  __HAL_RCC_GPIOC_CLK_ENABLE();
  __HAL_RCC_GPIOH_CLK_ENABLE();
  __HAL_RCC_GPIOA_CLK_ENABLE();
  __HAL_RCC_GPIOB_CLK_ENABLE();

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(GPIOA, GPIO_PIN_6, GPIO_PIN_RESET);

  /*Configure GPIO pin : B1_Pin */
  GPIO_InitStruct.Pin = B1_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_IT_FALLING;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  HAL_GPIO_Init(B1_GPIO_Port, &GPIO_InitStruct);

  /*Configure GPIO pin : PA6 */
  GPIO_InitStruct.Pin = GPIO_PIN_6;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

}

/* USER CODE BEGIN 4 */

float32_t LAG(float32_t xn, float32_t ts, float32_t tau, float32_t *xn_1, float32_t *yn_1)
{
  float32_t Two = 2.0;
  float32_t a = ts;
  float32_t b = ts;
  float32_t c = Two * tau + ts;
  float32_t d = -Two * tau + ts;
  float32_t yn = 0.0;
  yn = (-(*yn_1)*d + xn*a + (*xn_1)*b)/c;
  *xn_1 = xn;
  *yn_1 = yn;
  return yn;
}
float32_t INTEGRATE(float32_t xn, float32_t ts, float32_t upper, float32_t lower, float32_t *xn_1, float32_t *yn_1)
{
  float32_t Two = 2.0;
  float32_t a = ts/Two;
  float32_t yn = 0.0;
  yn = *yn_1 + a*(xn + *xn_1);
  if(yn >= upper) yn = upper;
  if(yn <= lower) yn = lower;
  *xn_1 = xn;
  *yn_1 = yn;
  return yn;
}
float32_t HIPASS(float32_t xn, float32_t ts, float32_t tau, float32_t *xn_1, float32_t *yn_1)
{
  float32_t One = 1.0;
  float32_t result = 0.0;
  float32_t a = 0.0;

  a = LAG(xn, ts, tau, xn_1, yn_1);
  result = One*xn - a;
  return result;
}

/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
