/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
/*
name: example001
date: 06-04-2018
purpose:
example001 - Based on example019 from the MPU9250 directory.
Try to drive a conventional ESC with a 20 msec standard RC cycle time.
*/

/*
name: example002
date: 06-10-2018
purpose:
example002 - Use Higher Resolution
Try to drive a conventional ESC with a 20 msec standard RC cycle time.
*/

/*
name: example003
date: 07-27-2018
purpose:
example003 - Add a timer to read the pulse from the HC-SR04 Sonar.
*/

/*
name: example004
date: 08-19-2018
purpose:
example004 - Try 4.26 CubeMx.
*/

/*
name: example005
date: 08-26-2018
purpose:
example005 - Try AT24C256 EEPROM on I2C2.
*/

/*
name: example006
date: 08-27-2018
purpose:
example006 - Add RDF77402 Distance Sensor - Sparkfun I2C3
*/

/*
name: example007
date: 09-06-2018
purpose:
example007 - Add RDF77402 Distance Sensor - Sparkfun I2C3
example006 didn't work out - try to follow the datasheet instructions.
*/

/*
name: example009-ESC
date: 12-02-2018
purpose:
example009-ESC - Add CCPM SERVO CONSISTENCY MASTER - TIM12_CH1 = PB14
Read the knob using timers.
*/

/*
name: example010-ESC
date: 09-14-2019
purpose:
example010-ESC - Add RPM Sensor Hobbywing - TIM1_CH1 = PE9.
*/

/*
name: example010R1-ESC
date: 07-01-2022
purpose:
example010R1-ESC - Add RPM Sensor Hobbywing - TIM1_CH1 = PE9.
Same as example010-ESC - Relearning.
*/

/*
name: example010R2-ESC
date: 07-02-2022
purpose:
example010R1-ESC - Add RPM Sensor Hobbywing - TIM1_CH1 = PE9.
Same as example010R1-ESC - Relearning. - Recreate from scratch.
*/

/*
name: example010R3-ESC
date: 07-03-2022
purpose:
example010R1-ESC - Add RPM Sensor Hobbywing - TIM1_CH1 = PE9.
Same as example010R3-ESC - Relearning. - Recreate from scratch.
*/

#include <stdio.h>
#include <math.h>
//#define ARM_MATH_CM4
#include "arm_math.h"

// Register names according to the datasheet.
// According to the InvenSense document
// "MPU-9250 Register Map and Descriptions Revision 4.0",

#define MPU9250_SELF_TEST_X        0x0D   // R/W
#define MPU9250_SELF_TEST_Y        0x0E   // R/W
#define MPU9250_SELF_TEST_Z        0x0F   // R/W
#define MPU9250_SELF_TEST_A        0x10   // R/W
#define MPU9250_SMPLRT_DIV         0x19   // R/W
#define MPU9250_CONFIG             0x1A   // R/W
#define MPU9250_GYRO_CONFIG        0x1B   // R/W
#define MPU9250_ACCEL_CONFIG       0x1C   // R/W
#define MPU9250_FF_THR             0x1D   // R/W
#define MPU9250_FF_DUR             0x1E   // R/W
#define MPU9250_MOT_THR            0x1F   // R/W
#define MPU9250_MOT_DUR            0x20   // R/W
#define MPU9250_ZRMOT_THR          0x21   // R/W
#define MPU9250_ZRMOT_DUR          0x22   // R/W
#define MPU9250_FIFO_EN            0x23   // R/W
#define MPU9250_I2C_MST_CTRL       0x24   // R/W
#define MPU9250_I2C_SLV0_ADDR      0x25   // R/W
#define MPU9250_I2C_SLV0_REG       0x26   // R/W
#define MPU9250_I2C_SLV0_CTRL      0x27   // R/W
#define MPU9250_I2C_SLV1_ADDR      0x28   // R/W
#define MPU9250_I2C_SLV1_REG       0x29   // R/W
#define MPU9250_I2C_SLV1_CTRL      0x2A   // R/W
#define MPU9250_I2C_SLV2_ADDR      0x2B   // R/W
#define MPU9250_I2C_SLV2_REG       0x2C   // R/W
#define MPU9250_I2C_SLV2_CTRL      0x2D   // R/W
#define MPU9250_I2C_SLV3_ADDR      0x2E   // R/W
#define MPU9250_I2C_SLV3_REG       0x2F   // R/W
#define MPU9250_I2C_SLV3_CTRL      0x30   // R/W
#define MPU9250_I2C_SLV4_ADDR      0x31   // R/W
#define MPU9250_I2C_SLV4_REG       0x32   // R/W
#define MPU9250_I2C_SLV4_DO        0x33   // R/W
#define MPU9250_I2C_SLV4_CTRL      0x34   // R/W
#define MPU9250_I2C_SLV4_DI        0x35   // R  
#define MPU9250_I2C_MST_STATUS     0x36   // R
#define MPU9250_INT_PIN_CFG        0x37   // R/W
#define MPU9250_INT_ENABLE         0x38   // R/W
#define MPU9250_INT_STATUS         0x3A   // R  
#define MPU9250_ACCEL_XOUT_H       0x3B   // R  
#define MPU9250_ACCEL_XOUT_L       0x3C   // R  
#define MPU9250_ACCEL_YOUT_H       0x3D   // R  
#define MPU9250_ACCEL_YOUT_L       0x3E   // R  
#define MPU9250_ACCEL_ZOUT_H       0x3F   // R  
#define MPU9250_ACCEL_ZOUT_L       0x40   // R  
#define MPU9250_TEMP_OUT_H         0x41   // R  
#define MPU9250_TEMP_OUT_L         0x42   // R  
#define MPU9250_GYRO_XOUT_H        0x43   // R  
#define MPU9250_GYRO_XOUT_L        0x44   // R  
#define MPU9250_GYRO_YOUT_H        0x45   // R  
#define MPU9250_GYRO_YOUT_L        0x46   // R  
#define MPU9250_GYRO_ZOUT_H        0x47   // R  
#define MPU9250_GYRO_ZOUT_L        0x48   // R  
#define MPU9250_EXT_SENS_DATA_00   0x49   // R  
#define MPU9250_EXT_SENS_DATA_01   0x4A   // R  
#define MPU9250_EXT_SENS_DATA_02   0x4B   // R  
#define MPU9250_EXT_SENS_DATA_03   0x4C   // R  
#define MPU9250_EXT_SENS_DATA_04   0x4D   // R  
#define MPU9250_EXT_SENS_DATA_05   0x4E   // R  
#define MPU9250_EXT_SENS_DATA_06   0x4F   // R  
#define MPU9250_EXT_SENS_DATA_07   0x50   // R  
#define MPU9250_EXT_SENS_DATA_08   0x51   // R  
#define MPU9250_EXT_SENS_DATA_09   0x52   // R  
#define MPU9250_EXT_SENS_DATA_10   0x53   // R  
#define MPU9250_EXT_SENS_DATA_11   0x54   // R  
#define MPU9250_EXT_SENS_DATA_12   0x55   // R  
#define MPU9250_EXT_SENS_DATA_13   0x56   // R  
#define MPU9250_EXT_SENS_DATA_14   0x57   // R  
#define MPU9250_EXT_SENS_DATA_15   0x58   // R  
#define MPU9250_EXT_SENS_DATA_16   0x59   // R  
#define MPU9250_EXT_SENS_DATA_17   0x5A   // R  
#define MPU9250_EXT_SENS_DATA_18   0x5B   // R  
#define MPU9250_EXT_SENS_DATA_19   0x5C   // R  
#define MPU9250_EXT_SENS_DATA_20   0x5D   // R  
#define MPU9250_EXT_SENS_DATA_21   0x5E   // R  
#define MPU9250_EXT_SENS_DATA_22   0x5F   // R  
#define MPU9250_EXT_SENS_DATA_23   0x60   // R  
#define MPU9250_MOT_DETECT_STATUS  0x61   // R  
#define MPU9250_I2C_SLV0_DO        0x63   // R/W
#define MPU9250_I2C_SLV1_DO        0x64   // R/W
#define MPU9250_I2C_SLV2_DO        0x65   // R/W
#define MPU9250_I2C_SLV3_DO        0x66   // R/W
#define MPU9250_I2C_MST_DELAY_CTRL 0x67   // R/W
#define MPU9250_SIGNAL_PATH_RESET  0x68   // R/W
#define MPU9250_MOT_DETECT_CTRL    0x69   // R/W
#define MPU9250_USER_CTRL          0x6A   // R/W
#define MPU9250_PWR_MGMT_1         0x6B   // R/W
#define MPU9250_PWR_MGMT_2         0x6C   // R/W
#define MPU9250_FIFO_COUNTH        0x72   // R/W
#define MPU9250_FIFO_COUNTL        0x73   // R/W
#define MPU9250_FIFO_R_W           0x74   // R/W
#define MPU9250_WHO_AM_I           0x75   // R - Data should be 0x71

//MPU9250 Compass
#define MPU9250_CMPS_XOUT_L        0x03   // R
#define MPU9250_CMPS_XOUT_H        0x04   // R
#define MPU9250_CMPS_YOUT_L        0x05   // R
#define MPU9250_CMPS_YOUT_H        0x06   // R
#define MPU9250_CMPS_ZOUT_L        0x07   // R
#define MPU9250_CMPS_ZOUT_H        0x08   // R
#define MPU9250_CMPS_WIA           0x00   // R - Data should be 0x48
#define MPU9250_CMPS_CNTL          0x0A   // R/W
#define MPU9250_CMPS_ST1           0x02   // R - Data is read when 0x01


// I2C address 0x69 could be 0x68 depends on your wiring. 
#define MPU9250_I2C_ADDRESS        0x68

#define MPU9250_CMPS_I2C_ADDRESS   0x0C

#define AT24C256_I2C_ADDRESS       0x50

/* I2C for the RFD77402 */
#define RFD77402_ADDR           0x4C
#define RFD77402_MOD_CHIP_ID    0x28
#define RFD77402_COMMAND        0x04
#define RFD77402_DEVICE_STATUS  0x06
#define RFD77402_ICSR           0x00
#define RFD77402_INTERRUPTS     0x02
#define RFD77402_CONFIGURE_I2C  0X1C
#define RFD77402_CONFIGURE_PMU  0X14
#define RFD77402_CONFIGURE_A    0X0C
#define RFD77402_CONFIGURE_B    0X0E
#define RFD77402_CONFIGURE_HW_0 0X22
#define RFD77402_CONFIGURE_HW_1 0X24
#define RFD77402_CONFIGURE_HW_2 0X24
#define RFD77402_CONFIGURE_HW_3 0X26
#define RFD77402_RESULT         0x08
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
ADC_HandleTypeDef hadc1;
DMA_HandleTypeDef hdma_adc1;

DAC_HandleTypeDef hdac;

I2C_HandleTypeDef hi2c1;
I2C_HandleTypeDef hi2c2;
I2C_HandleTypeDef hi2c3;

TIM_HandleTypeDef htim1;
TIM_HandleTypeDef htim3;
TIM_HandleTypeDef htim4;
TIM_HandleTypeDef htim9;
TIM_HandleTypeDef htim12;

UART_HandleTypeDef huart3;

/* USER CODE BEGIN PV */
__IO uint16_t interrupt_flag = 1; /* This is used to determine if the frame should be executed. */

/* instrumentation parameters. */
__no_init float32_t i_fbuffer01[1200]; // Instrumentation floating buffer01
__no_init float32_t i_fbuffer02[1200]; // Instrumentation floating buffer02
__no_init float32_t i_fbuffer03[1200]; // Instrumentation floating buffer03
__no_init uint32_t i_ibuffer01[1200]; // Instrumentation integer buffer01
uint32_t i_index1 = 0, i_index2 = 1000, i_index3 = 0;
uint16_t user_switch = 0;

HAL_StatusTypeDef HAL_Status;

uint32_t frame_counter = 0; /* This is the frame counter. */
float32_t ts = 0.002; /* (sec) - This is the time increment for a 500 Hz update rate. */
float32_t atime = 0.0; /* (sec) - This is the time since power-up. */
uint16_t user_count = 25; /* Skip every 25 to make a 20 Hz update rate. */
uint16_t user_counter = 0; /* Needed to skip every 25 to make a 20 Hz update rate.*/
uint16_t user_count1 = 50; /* Skip every 50 to make a 10 Hz update rate. */
uint16_t user_counter1 = 0; /* Needed to skip every 50 to make a 10 Hz update rate.*/

uint8_t who_am_i = 0;
uint8_t who_am_i_compass = 0;

uint8_t accel_x_high = 0;
uint8_t accel_x_low = 0;
int16_t accel_x_raw = 0; /* This is the raw accel_x in fixed point */
float32_t accel_x = 0; /* This is the accel_x in fpss. */

uint8_t accel_y_high = 0;
uint8_t accel_y_low = 0;
int16_t accel_y_raw = 0; /* This is the raw accel_y in fixed point */
float32_t accel_y = 0; /* This is the accel_y in fpss. */

uint8_t accel_z_high = 0;
uint8_t accel_z_low = 0;
int16_t accel_z_raw = 0; /* This is the raw accel_z in fixed point */
float32_t accel_z = 0; /* This is the accel_z in fpss. */

uint8_t temperature_high = 0;
uint8_t temperature_low = 0;
int16_t temperature_raw = 0; /* This is the raw temperature in fixed point */
float32_t temperature = 0; /* This is the temperature in degC. */

uint8_t gyro_x_high = 0;
uint8_t gyro_x_low = 0;
int16_t gyro_x_raw = 0; /* This is the raw gyro_x in fixed point */
float32_t gyro_x = 0; /* This is the gyro_x in dps. */

uint8_t gyro_y_high = 0;
uint8_t gyro_y_low = 0;
int16_t gyro_y_raw = 0; /* This is the raw gyro_y in fixed point */
float32_t gyro_y = 0; /* This is the gyro_y in dps. */

uint8_t gyro_z_high = 0;
uint8_t gyro_z_low = 0;
int16_t gyro_z_raw = 0; /* This is the raw gyro_z in fixed point */
float32_t gyro_z = 0; /* This is the gyro_z in dps. */

uint8_t compass_x_high = 0;
uint8_t compass_x_low = 0;
int16_t compass_x_raw = 0; /* This is the raw compass_x in fixed point */
float32_t compass_x = 0; /* This is the compass_x in micro-Tesla. */

uint8_t compass_y_high = 0;
uint8_t compass_y_low = 0;
int16_t compass_y_raw = 0; /* This is the raw compass_y in fixed point */
float32_t compass_y = 0; /* This is the compass_y in micro-Tesla. */

uint8_t compass_z_high = 0;
uint8_t compass_z_low = 0;
int16_t compass_z_raw = 0; /* This is the raw compass_z in fixed point */
float32_t compass_z = 0; /* This is the compass_z in micro-Tesla. */

/* Set default command here 0.5 msec = 420. */
/* To run the motor set d_pwm_fix to 1100. */
/* To stop the motor set d_pwm_fix to 1000. */
uint16_t a_pwm_fix=1000,b_pwm_fix=1000,c_pwm_fix=1000,d_pwm_fix=1000;

/* accel LPFs. */
float32_t accel_x_xn_1 = 0.0, accel_x_yn = 0.0, accel_x_yn_1 = 0.0;
float32_t accel_x_tau = 0.005, accel_x_filt = 0.0;

float32_t accel_y_xn_1 = 0.0, accel_y_yn = 0.0, accel_y_yn_1 = 0.0;
float32_t accel_y_tau = 0.005, accel_y_filt = 0.0;

float32_t accel_z_xn_1 = 0.0, accel_z_yn = 0.0, accel_z_yn_1 = 0.0;
float32_t accel_z_tau = 0.005, accel_z_filt = 0.0;

/* gyro LPFs. */
float32_t q_xn_1 = 0.0, q_yn = 0.0, q_yn_1 = 0.0;
float32_t q_tau = 0.005, q_filt = 0.0;

float32_t p_xn_1 = 0.0, p_yn = 0.0, p_yn_1 = 0.0;
float32_t p_tau = 0.005, p_filt = 0.0;

float32_t r_xn_1 = 0.0, r_yn = 0.0, r_yn_1 = 0.0;
float32_t r_tau = 0.005, r_filt = 0.0;

/* Array to read MPU-9250 in Burst Mode. */
uint8_t RxBuffer1[14];
uint8_t RxBuffer2[6];
uint8_t compass_flag = 0, compass_counter = 0;

/* ADC & DAC */
uint32_t ADC_Raw[6] = {0,0,0,0,0,0};
uint16_t ADC_Signal_Raw1 = 0, ADC_Signal_Raw2 = 0, ADC_Signal_Raw3 = 0;
uint16_t ADC_Signal_Raw4 = 0, ADC_Signal_Raw5 = 0, ADC_Signal_Raw6 = 0;
float32_t ADC_Signal_1 = 0.0, ADC_Signal_2 = 0.0, ADC_Signal_3 = 0.0;
float32_t ADC_Signal_4 = 0.0, ADC_Signal_5 = 0.0, ADC_Signal_6 = 0.0;

uint32_t DAC_Raw1 = 1000, DAC_Raw2 = 2000;
float32_t DAC_Signal_1 = 0.0, DAC_Signal_2 = 0.0;

/* ADC to DAC 10 Hz LPF Test. */
float32_t adc1_xn_1 = 0.0, adc1_yn = 0.0, adc1_yn_1 = 0.0;
float32_t adc1_tau = 0.0159, adc1_filt = 0.0;

/* Sonar Pulse Input Capture Value. */
uint32_t sonar_pulse_echo_capture1 = 0;
uint32_t sonar_pulse_echo_capture2 = 0;
uint32_t sonar_pulse_echo_captured = 0;
float32_t sonar_pulse_echo_sec = 0.0;
float32_t sonar_pulse_echo_inches = 0.0;
uint16_t altitude_valid = 0;

/* AT24C256 - Memory Locations to Store Data. */
uint8_t AT24C256_M0000 = 0;
uint8_t AT24C256_M0001 = 0;
uint8_t AT24C256_M0002 = 0;
uint8_t AT24C256_M0003 = 0;

/* RFD77402 - Parameters. */
uint8_t RFD77402_Lower_Temp = 0, RFD77402_Higher_Temp = 0;
uint16_t RFD77402_ID = 0;
uint8_t RFD77402_01 = 0, RFD77402_02 = 0, RFD77402_03 = 0;
uint8_t RFD77402_04 = 0, RFD77402_05 = 0, RFD77402_06 = 0;
uint8_t RFD77402_07 = 0, RFD77402_08 = 0;
int16_t RFD77402_Height_mm = 0, RFD77402_Height = 0;
float32_t RFD77402_Height_Inches = 0.0;
uint16_t RFD77402_Err_code = 0, RFD77402_Valid = 0;
uint16_t RFD77402_RSLT_CNFDR = 0, RFD77402_VAL_PIXELS = 0, RFD77402_VEC_AMPL = 0;

/* TIM12_CH1 = PB14 - Read Knob of Servo Simulator. */
uint32_t pulse_capture1 = 0;
uint32_t pulse_capture2 = 0;
uint32_t pulse_captured = 0;
float32_t pulse_sec = 0.0;

/* TIM1_CH1 = PE9 - Read RPM Sensor Pulse. */
uint32_t RPM1_pulse_capture1 = 0;
uint32_t RPM1_pulse_capture2 = 0;
uint32_t RPM1_pulse_captured = 0;
float32_t RPM1_pulse_sec = 0.0;
float32_t RPM1 = 0.0;
uint8_t RPM1_valid = 0;
/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
static void MX_GPIO_Init(void);
static void MX_DMA_Init(void);
static void MX_ADC1_Init(void);
static void MX_DAC_Init(void);
static void MX_I2C1_Init(void);
static void MX_I2C2_Init(void);
static void MX_I2C3_Init(void);
static void MX_TIM1_Init(void);
static void MX_TIM4_Init(void);
static void MX_TIM9_Init(void);
static void MX_TIM12_Init(void);
static void MX_USART3_UART_Init(void);
static void MX_TIM3_Init(void);
/* USER CODE BEGIN PFP */
void MPU9250_I2C_WriteData(uint16_t aaddress, uint8_t aregister, uint8_t adata);
uint8_t MPU9250_I2C_ReadData(uint16_t aaddress, uint8_t aregister);
float32_t LAG(float32_t xn, float32_t ts, float32_t tau, float32_t *xn_1, float32_t *yn_1);
float32_t INTEGRATE(float32_t xn, float32_t ts, float32_t upper, float32_t lower, float32_t *xn_1, float32_t *yn_1);
float32_t HIPASS(float32_t xn, float32_t ts, float32_t tau, float32_t *xn_1, float32_t *yn_1);
void MPU9250_I2C_ReadDataBurst14(uint16_t aaddress, uint8_t aregister, uint8_t RxBuffer[14]);
void MPU9250_I2C_ReadDataBurst6(uint16_t aaddress, uint8_t aregister, uint8_t RxBuffer[6]);
void AT24C256_I2C_WriteData(uint16_t aaddress, uint8_t aregister1, uint8_t aregister2, uint8_t adata);
uint8_t AT24C256_I2C_ReadData(uint16_t aaddress, uint8_t aregister1, uint8_t aregister2);
void RFD77402_I2C_WriteData(uint16_t aaddress, uint8_t aregister, uint8_t adata);
uint8_t RFD77402_I2C_ReadData(uint16_t aaddress, uint8_t aregister);
/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
  /* USER CODE BEGIN 1 */

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_DMA_Init();
  MX_ADC1_Init();
  MX_DAC_Init();
  MX_I2C1_Init();
  MX_I2C2_Init();
  MX_I2C3_Init();
  MX_TIM1_Init();
  MX_TIM4_Init();
  MX_TIM9_Init();
  MX_TIM12_Init();
  MX_USART3_UART_Init();
  MX_TIM3_Init();
  /* USER CODE BEGIN 2 */
  /* Enable the MPU-9250 Temperature Sensor. */
  MPU9250_I2C_WriteData(MPU9250_I2C_ADDRESS, MPU9250_PWR_MGMT_1, 0x00);
  
  /* Switch the Compass on the I2C Bus*/
  MPU9250_I2C_WriteData(MPU9250_I2C_ADDRESS, MPU9250_INT_PIN_CFG, 0x02);
  
  /* Expect to get 0x71 Back for "who_am_i". */
  who_am_i = MPU9250_I2C_ReadData(MPU9250_I2C_ADDRESS, MPU9250_WHO_AM_I);
  
  /* Expect to get 0x48 Back for "who_am_i_compass". */
  who_am_i_compass = MPU9250_I2C_ReadData(MPU9250_CMPS_I2C_ADDRESS, MPU9250_CMPS_WIA);
  
  /* Initially take a single read of the compass. */
  MPU9250_I2C_WriteData(MPU9250_CMPS_I2C_ADDRESS, MPU9250_CMPS_CNTL, 0x11);
  
  printf("\f\r\nWelcome to example010-ESC!!! - STM32F4-Discovery - MPU-9250 IMU");
  
  /* Use for instrumentation only. Ignor first time. */
  printf("\r\nbegin");
  for (i_index3 = 0; i_index3 < i_index2; i_index3++)
  {
    printf("\r\n%i %f %f %f" ,i_ibuffer01[i_index3], i_fbuffer01[i_index3], i_fbuffer02[i_index3], i_fbuffer03[i_index3]); 
  }
  printf("\r\nend");
  
  /* Start ADCs. */
  HAL_ADC_Start_DMA(&hadc1, (uint32_t *)ADC_Raw, 6);
  
  /* Start DACs. */
  HAL_DAC_Start(&hdac, DAC_CHANNEL_1);
  HAL_DAC_Start(&hdac, DAC_CHANNEL_2);

  /* Start the PWM. */
  HAL_TIM_PWM_Start(&htim4, TIM_CHANNEL_1);
  HAL_TIM_PWM_Start(&htim4, TIM_CHANNEL_2);
  HAL_TIM_PWM_Start(&htim4, TIM_CHANNEL_3);
  HAL_TIM_PWM_Start(&htim4, TIM_CHANNEL_4);
  
  /* Start the main timer. */
  HAL_TIM_OC_Start_IT(&htim3, TIM_CHANNEL_1);
  
  /* Start the Input Capture Timer for the Sonar. */
  HAL_TIM_IC_Start(&htim9, TIM_CHANNEL_1);
  HAL_TIM_IC_Start(&htim9, TIM_CHANNEL_2);
  
  /* Start the Input Capture Timer to read the servo simulator knob. */
  HAL_TIM_IC_Start(&htim12, TIM_CHANNEL_1);
  HAL_TIM_IC_Start(&htim12, TIM_CHANNEL_2);
  
  /* Start the Input Capture Timer to read the RPM1 Sensor. */
  HAL_TIM_IC_Start(&htim1, TIM_CHANNEL_1);
  HAL_TIM_IC_Start(&htim1, TIM_CHANNEL_2);

  /* AT24C256 - EEPROM  Write and Read some data. */
  AT24C256_I2C_WriteData(AT24C256_I2C_ADDRESS, 0x00, 0x00, 0x12);
  AT24C256_I2C_WriteData(AT24C256_I2C_ADDRESS, 0x00, 0x01, 0x34);
  AT24C256_I2C_WriteData(AT24C256_I2C_ADDRESS, 0x00, 0x02, 0x56);
  AT24C256_I2C_WriteData(AT24C256_I2C_ADDRESS, 0x00, 0x03, 0x78);
  AT24C256_M0000 = AT24C256_I2C_ReadData(AT24C256_I2C_ADDRESS, 0x00, 0x00);
  AT24C256_M0001 = AT24C256_I2C_ReadData(AT24C256_I2C_ADDRESS, 0x00, 0x01);
  AT24C256_M0002 = AT24C256_I2C_ReadData(AT24C256_I2C_ADDRESS, 0x00, 0x02);
  AT24C256_M0003 = AT24C256_I2C_ReadData(AT24C256_I2C_ADDRESS, 0x00, 0x03);
  
  /* RFD77402 - Distance Sensor. */
  /* Get ID - It should be 0xAD02 */
  RFD77402_Lower_Temp = RFD77402_I2C_ReadData(RFD77402_ADDR, RFD77402_MOD_CHIP_ID);
  RFD77402_Higher_Temp = RFD77402_I2C_ReadData(RFD77402_ADDR, RFD77402_MOD_CHIP_ID+0x01);
  RFD77402_ID = (uint16_t)(RFD77402_Higher_Temp << 8 | RFD77402_Lower_Temp);
  
  /* Check if in Standby State. Expected Result is 0x00. */
  HAL_Delay(100);
  RFD77402_01 = RFD77402_I2C_ReadData(RFD77402_ADDR, 0x06);

  /* Set ICSR to 0x04 to set INT_MODE. */
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x00, 0x04);
  
  /* Set CONFIGURE_I2C to 0x65. */
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x1C, 0x65);
  
  /* Set Initialization to 0x05. */
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x15, 0x05);
  
  /* Set MPU OFF. */
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x04, 0x91);
  
  /* Check if in OFF State. Expected Result is 0xB0. */
  HAL_Delay(100);
  RFD77402_02 = RFD77402_I2C_ReadData(RFD77402_ADDR, 0x06);

  /* Set Initialization to 0x06. */
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x15, 0x06);
  
  /* Set MPU ON. */
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x04, 0x92);
  
  /* Check if MPU ON. Expected Result is 0xF8. */
  HAL_Delay(100);
  RFD77402_03 = RFD77402_I2C_ReadData(RFD77402_ADDR, 0x06);

  /* TOF Configuration. */
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x0C, 0x00);
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x0D, 0xE1);
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x0E, 0xFF);
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x0F, 0x10);
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x20, 0xD0);
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x21, 0x07);
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x22, 0x08);
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x23, 0x50);
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x24, 0x41);
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x25, 0xA0);
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x26, 0xD4);
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x27, 0x45);

  /* Set to Standyby State. */
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x04, 0x90);
  
  /* Check if in Standby State. Expected Result is 0x00. */
  HAL_Delay(100);
  RFD77402_04 = RFD77402_I2C_ReadData(RFD77402_ADDR, 0x06);

  /* ------------------- */
  /* Set Initialization to 0x05. */
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x15, 0x05);
  
  /* Set MPU OFF. */
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x04, 0x91);
   
  /* Check if MPU OFF. Expected Result is 0xB0. */
  HAL_Delay(100);
  RFD77402_05 = RFD77402_I2C_ReadData(RFD77402_ADDR, 0x06);

  /* Set Initialization to 0x06. */
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x15, 0x06);
  
  /* Set MPU ON. */
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x04, 0x92);
   
  /* Check if MPU ON. Expected Result is 0xF8. */
  HAL_Delay(100);
  RFD77402_06 = RFD77402_I2C_ReadData(RFD77402_ADDR, 0x06);
 
  /* Single Measure Command. */
  HAL_Delay(100);
  RFD77402_I2C_WriteData(RFD77402_ADDR, 0x04, 0x81);
  
  /* Read Status. Expected Result is 0x94. */
  HAL_Delay(100);
  RFD77402_07 = RFD77402_I2C_ReadData(RFD77402_ADDR, 0x00);
  
  /* Read Result. */
  HAL_Delay(100);
  RFD77402_Lower_Temp = RFD77402_I2C_ReadData(RFD77402_ADDR, 0x08);
  HAL_Delay(100);
  RFD77402_Higher_Temp = RFD77402_I2C_ReadData(RFD77402_ADDR, 0x09);
  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
  while (1)
  {
    /* USER CODE END WHILE */
    if(interrupt_flag)
    {
      HAL_GPIO_WritePin(GPIOB, GPIO_PIN_12, GPIO_PIN_SET);
      frame_counter++;
      atime = ts * frame_counter;
      
      /* Generate a pulse for the Sonar. (Skip every 25 = 20 Hz update rate). */
      if(user_counter == 0)
      {
        HAL_GPIO_WritePin(GPIOB, GPIO_PIN_13, GPIO_PIN_SET);
        
        /* Start the Input Capture Timer for the Sonar. */
        //HAL_TIM_IC_Start(&htim9, TIM_CHANNEL_1);
        //HAL_TIM_IC_Start(&htim9, TIM_CHANNEL_2);
      }
      if(user_counter == 1)
      {
        HAL_GPIO_WritePin(GPIOB, GPIO_PIN_13, GPIO_PIN_RESET);
      }
      user_counter++;
      if(user_counter == user_count)
      {
        user_counter = 0;
        /* Stop the Input Capture Timer for the Sonar. */
        //HAL_TIM_IC_Stop(&htim9, TIM_CHANNEL_1);
        //HAL_TIM_IC_Stop(&htim9, TIM_CHANNEL_2);
        
        /* Read the Sonar. */
        sonar_pulse_echo_capture1 = HAL_TIM_ReadCapturedValue(&htim9, TIM_CHANNEL_1);
        sonar_pulse_echo_capture2 = HAL_TIM_ReadCapturedValue(&htim9, TIM_CHANNEL_2);
        sonar_pulse_echo_captured = sonar_pulse_echo_capture2 - sonar_pulse_echo_capture1;
        sonar_pulse_echo_sec = 128.0/168000000.0*(float32_t)sonar_pulse_echo_captured;
        sonar_pulse_echo_inches = sonar_pulse_echo_sec/0.000148;
        if(sonar_pulse_echo_inches <= 157.48)
        {
          altitude_valid = 1;
        }
        else
        {
          altitude_valid = 0;
        }
      }
      
      /* Read the servo simulator.*/      
      pulse_capture1 = HAL_TIM_ReadCapturedValue(&htim12, TIM_CHANNEL_1);
      pulse_capture2 = HAL_TIM_ReadCapturedValue(&htim12, TIM_CHANNEL_2);
      pulse_captured = pulse_capture2 - pulse_capture1;
      pulse_sec = 128.0/84000000.0*(float32_t)pulse_captured;
      
      /* Read RPM1 sensor.*/      
      RPM1_pulse_capture1 = HAL_TIM_ReadCapturedValue(&htim1, TIM_CHANNEL_1);
      RPM1_pulse_capture2 = HAL_TIM_ReadCapturedValue(&htim1, TIM_CHANNEL_2);
      RPM1_pulse_captured = RPM1_pulse_capture2 - RPM1_pulse_capture1;
      RPM1_pulse_sec = 128.0/168000000.0*(float32_t)RPM1_pulse_captured;
      
      if(RPM1_pulse_sec > 0.0001 && RPM1_pulse_sec < 0.02 )
      {
        RPM1 = 10.0/RPM1_pulse_sec/2.3;
        RPM1_valid = 1;
      }
      else
      {
        RPM1 = RPM1;
        RPM1_valid = 0;
      }
  
      
      /* Processing for the RFD77402 Sensor (Skip every 50 = 10 Hz update rate). */
      if(user_counter1 == 0)
      {
      /* Read Result. */
      RFD77402_Lower_Temp = RFD77402_I2C_ReadData(RFD77402_ADDR, 0x08);
      RFD77402_Higher_Temp = RFD77402_I2C_ReadData(RFD77402_ADDR, 0x09);
      RFD77402_Height = (int16_t)(RFD77402_Higher_Temp << 8 | RFD77402_Lower_Temp);
      RFD77402_Height_mm = 0x1FFC & RFD77402_Height;
      RFD77402_Height_mm = RFD77402_Height_mm >> 2;
      RFD77402_Height_Inches = ((float32_t)RFD77402_Height_mm)*0.0393701;
      RFD77402_Err_code = 0x6000 & RFD77402_Height;
      RFD77402_Valid = 0x8000 & RFD77402_Height;
      RFD77402_Lower_Temp = RFD77402_I2C_ReadData(RFD77402_ADDR, 0x0A);
      RFD77402_Higher_Temp = RFD77402_I2C_ReadData(RFD77402_ADDR, 0x0B);
      RFD77402_RSLT_CNFDR = (uint16_t)(RFD77402_Higher_Temp << 8 | RFD77402_Lower_Temp);
      RFD77402_VAL_PIXELS = 0x000F & RFD77402_RSLT_CNFDR;
      RFD77402_VEC_AMPL = 0x7FF0 & RFD77402_RSLT_CNFDR;
      RFD77402_VEC_AMPL = RFD77402_VEC_AMPL >> 4;
      }
      if(user_counter1 == 25)
      {
        RFD77402_08 = RFD77402_I2C_ReadData(RFD77402_ADDR, 0x00);
        /* Make the next measurement. */ 
        RFD77402_I2C_WriteData(RFD77402_ADDR, 0x04, 0x81);
      }
      user_counter1++;
      if(user_counter1 == user_count1)
      {
        user_counter1 = 0;
      }
      
      /* Read ADCs. */
      ADC_Signal_Raw1 = (uint16_t)ADC_Raw[0]; // IN1=PA1
      ADC_Signal_Raw2 = (uint16_t)ADC_Raw[1]; // IN2=PA6
      ADC_Signal_Raw3 = (uint16_t)ADC_Raw[2]; // IN3=PA7
      ADC_Signal_Raw4 = (uint16_t)ADC_Raw[3]; // IN8=PB0
      ADC_Signal_Raw5 = (uint16_t)ADC_Raw[4]; // IN9=PB1
      ADC_Signal_Raw6 = (uint16_t)ADC_Raw[5]; // IN11=PC0
      ADC_Signal_1 = (float32_t)ADC_Signal_Raw1;
      ADC_Signal_2 = (float32_t)ADC_Signal_Raw2;
      ADC_Signal_3 = (float32_t)ADC_Signal_Raw3;
      ADC_Signal_4 = (float32_t)ADC_Signal_Raw4;
      ADC_Signal_5 = (float32_t)ADC_Signal_Raw5;
      ADC_Signal_6 = (float32_t)ADC_Signal_Raw6;
      
      /* Read Data In a Burst Mode. */
      MPU9250_I2C_ReadDataBurst14(MPU9250_I2C_ADDRESS, MPU9250_ACCEL_XOUT_H, RxBuffer1);
      
      if(compass_flag)
      {
      /* Read Data In a Burst Mode. */
      MPU9250_I2C_ReadDataBurst6(MPU9250_CMPS_I2C_ADDRESS, MPU9250_CMPS_XOUT_L, RxBuffer2);
      
      /* Set to take another compass read for the next iteration */
      MPU9250_I2C_WriteData(MPU9250_CMPS_I2C_ADDRESS, MPU9250_CMPS_CNTL, 0x11);
  
      compass_flag = 0;
      compass_counter = 1;
      }
      else
      {
        compass_counter++;
        if(compass_counter >= 5)
        {
          compass_counter = 0;
          compass_flag = 1;
        }
          
      }
  
      accel_x_high = RxBuffer1[0];
      accel_x_low = RxBuffer1[1];
      accel_y_high = RxBuffer1[2];
      accel_y_low = RxBuffer1[3];
      accel_z_high = RxBuffer1[4];
      accel_z_low = RxBuffer1[5];
      temperature_high = RxBuffer1[6];
      temperature_low = RxBuffer1[7];
      gyro_x_high = RxBuffer1[8];
      gyro_x_low = RxBuffer1[9];
      gyro_y_high = RxBuffer1[10];
      gyro_y_low = RxBuffer1[11];
      gyro_z_high = RxBuffer1[12];
      gyro_z_low = RxBuffer1[13];
      compass_x_low = RxBuffer2[0];
      compass_x_high = RxBuffer2[1];
      compass_y_low = RxBuffer2[2];
      compass_y_high = RxBuffer2[3];
      compass_z_low = RxBuffer2[4];
      compass_z_high = RxBuffer2[5];
   
      /* Read and process the accel_x (fpss). */
      accel_x_raw = (int16_t)(accel_x_high << 8 | accel_x_low);
      accel_x = (float32_t)(int16_t)accel_x_raw/(float32_t)509.23106;
      
      /* Read and process the accel_y (fpss). */
      accel_y_raw = (int16_t)(accel_y_high << 8 | accel_y_low);
      accel_y = (float32_t)(int16_t)accel_y_raw/(float32_t)509.23106;

      /* Read and process the accel_z (fpss). */
      accel_z_raw = (int16_t)(accel_z_high << 8 | accel_z_low);
      accel_z = (float32_t)(int16_t)accel_z_raw/(float32_t)509.23106;

      /* Read and process the temperature in degC. */
      temperature_raw = (int16_t)(temperature_high << 8 | temperature_low);
      temperature = ((float32_t)(int16_t)temperature_raw + (float32_t)7011.27)/(float32_t)333.87;
      
      /* Read and process the gyro_x (dps). */
      gyro_x_raw = (int16_t)(gyro_x_high << 8 | gyro_x_low);
      gyro_x = (float32_t)(int16_t)gyro_x_raw/(float32_t)131.0;
      
      /* Read and process the gyro_y (dps). */
      gyro_y_raw = (int16_t)(gyro_y_high << 8 | gyro_y_low);
      gyro_y = (float32_t)(int16_t)gyro_y_raw/(float32_t)131.0;

      /* Read and process the gyro_z (dps). */
      gyro_z_raw = (int16_t)(gyro_z_high << 8 | gyro_z_low);
      gyro_z = (float32_t)(int16_t)gyro_z_raw/(float32_t)131.0;
      
      /* Read and process the compass_x (micro-T). */
      compass_x_raw = (int16_t)(compass_x_high << 8 | compass_x_low);
      compass_x = (float32_t)(int16_t)compass_x_raw/(float32_t)0.15;

      /* Read and process the compass_y (micro-T). */
      compass_y_raw = (int16_t)(compass_y_high << 8 | compass_y_low);
      compass_y = (float32_t)(int16_t)compass_y_raw/(float32_t)0.15;
      
      /* Read and process the compass_z (micro-T). */
      compass_z_raw = (int16_t)(compass_z_high << 8 | compass_z_low);
      compass_z = (float32_t)(int16_t)compass_z_raw/(float32_t)0.15;       
      
      /* Accel Filters */
      accel_x_yn = LAG(accel_x, ts, accel_x_tau, &accel_x_xn_1, &accel_x_yn_1);
      accel_x_filt = accel_x_yn;
      
      accel_x_yn = LAG(accel_x, ts, accel_x_tau, &accel_x_xn_1, &accel_x_yn_1);
      accel_x_filt = accel_x_yn;
 
      accel_y_yn = LAG(accel_y, ts, accel_y_tau, &accel_y_xn_1, &accel_y_yn_1);
      accel_y_filt = accel_y_yn;

      accel_z_yn = LAG(accel_z, ts, accel_z_tau, &accel_z_xn_1, &accel_z_yn_1);
      accel_z_filt = accel_z_yn;
      
      /* Angular Rate Gyro  Filters */
      gyro_y = -gyro_y;
      q_yn = LAG(gyro_y, ts, q_tau, &q_xn_1, &q_yn_1);
      q_filt = q_yn; // With LPF
      //q_filt = gyro_y; // No LPF
      
      p_yn = LAG(gyro_x, ts, p_tau, &p_xn_1, &p_yn_1);
      p_filt = p_yn; // With LPF
      //p_filt = gyro_x; // No LPF
      
      gyro_z = -gyro_z;
      r_yn = LAG(gyro_z, ts, r_tau, &r_xn_1, &r_yn_1);
      r_filt = r_yn; // With LPF
      //r_filt = gyro_z; // No LPF
      
      /* ADC to DAC Lag Filter Test. */
      adc1_yn = LAG(ADC_Signal_1, ts, adc1_tau, &adc1_xn_1, &adc1_yn_1);
      adc1_filt = adc1_yn;
      
      /* Store Data on user switch press. */
      if(user_switch)
      {
        i_ibuffer01[i_index1] = frame_counter;
        i_fbuffer01[i_index1] = q_filt;
        i_fbuffer02[i_index1] = p_filt;
        i_fbuffer03[i_index1] = r_filt;
        i_index1++;
        if(i_index1 > i_index2)
        {
          user_switch = 0;
          i_index1 = 0;
        }
      }
      
      /* Check the user_switch. This will latch the users switch to take data. */
      /* After taking the data press reset to get the data from the UART. */
      if(!user_switch)
      {
        if(HAL_GPIO_ReadPin(GPIOA, GPIO_PIN_0)) user_switch = 1;
      }
          
      // In the debugger type in the a_pwm_fix, b_pwm_fix, c_pwm_fix, & d_pwm_fix
                 
      /* Write to DACs. */
      
      /* Wraparound for test purposes. */
      DAC_Signal_1 = adc1_filt;
      DAC_Raw1 = (uint32_t)DAC_Signal_1;
      
      HAL_DAC_SetValue(&hdac, DAC_CHANNEL_1, DAC_ALIGN_12B_R, DAC_Raw1); // PA4
      HAL_DAC_SetValue(&hdac, DAC_CHANNEL_2, DAC_ALIGN_12B_R, DAC_Raw2); // PA5

      /* PWM */
      __HAL_TIM_SET_COMPARE(&htim4, TIM_CHANNEL_1, b_pwm_fix); // PD12
      __HAL_TIM_SET_COMPARE(&htim4, TIM_CHANNEL_2, a_pwm_fix); // PD13
      __HAL_TIM_SET_COMPARE(&htim4, TIM_CHANNEL_3, c_pwm_fix); // PD14
      __HAL_TIM_SET_COMPARE(&htim4, TIM_CHANNEL_4, d_pwm_fix); // PD15
           
      /* Clear interrupt flag. */
      interrupt_flag = 0;
      HAL_GPIO_WritePin(GPIOB, GPIO_PIN_12, GPIO_PIN_RESET);
    }
    /* USER CODE BEGIN 3 */
  }
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Configure the main internal regulator output voltage 
  */
  __HAL_RCC_PWR_CLK_ENABLE();
  __HAL_PWR_VOLTAGESCALING_CONFIG(PWR_REGULATOR_VOLTAGE_SCALE1);
  /** Initializes the CPU, AHB and APB busses clocks 
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSE;
  RCC_OscInitStruct.HSEState = RCC_HSE_ON;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSE;
  RCC_OscInitStruct.PLL.PLLM = 4;
  RCC_OscInitStruct.PLL.PLLN = 168;
  RCC_OscInitStruct.PLL.PLLP = RCC_PLLP_DIV2;
  RCC_OscInitStruct.PLL.PLLQ = 4;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }
  /** Initializes the CPU, AHB and APB busses clocks 
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV4;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV2;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_5) != HAL_OK)
  {
    Error_Handler();
  }
}

/**
  * @brief ADC1 Initialization Function
  * @param None
  * @retval None
  */
static void MX_ADC1_Init(void)
{

  /* USER CODE BEGIN ADC1_Init 0 */

  /* USER CODE END ADC1_Init 0 */

  ADC_ChannelConfTypeDef sConfig = {0};

  /* USER CODE BEGIN ADC1_Init 1 */

  /* USER CODE END ADC1_Init 1 */
  /** Configure the global features of the ADC (Clock, Resolution, Data Alignment and number of conversion) 
  */
  hadc1.Instance = ADC1;
  hadc1.Init.ClockPrescaler = ADC_CLOCK_SYNC_PCLK_DIV4;
  hadc1.Init.Resolution = ADC_RESOLUTION_12B;
  hadc1.Init.ScanConvMode = ENABLE;
  hadc1.Init.ContinuousConvMode = DISABLE;
  hadc1.Init.DiscontinuousConvMode = DISABLE;
  hadc1.Init.ExternalTrigConvEdge = ADC_EXTERNALTRIGCONVEDGE_RISINGFALLING;
  hadc1.Init.ExternalTrigConv = ADC_EXTERNALTRIGCONV_T3_TRGO;
  hadc1.Init.DataAlign = ADC_DATAALIGN_RIGHT;
  hadc1.Init.NbrOfConversion = 6;
  hadc1.Init.DMAContinuousRequests = ENABLE;
  hadc1.Init.EOCSelection = ADC_EOC_SEQ_CONV;
  if (HAL_ADC_Init(&hadc1) != HAL_OK)
  {
    Error_Handler();
  }
  /** Configure for the selected ADC regular channel its corresponding rank in the sequencer and its sample time. 
  */
  sConfig.Channel = ADC_CHANNEL_1;
  sConfig.Rank = 1;
  sConfig.SamplingTime = ADC_SAMPLETIME_3CYCLES;
  if (HAL_ADC_ConfigChannel(&hadc1, &sConfig) != HAL_OK)
  {
    Error_Handler();
  }
  /** Configure for the selected ADC regular channel its corresponding rank in the sequencer and its sample time. 
  */
  sConfig.Channel = ADC_CHANNEL_6;
  sConfig.Rank = 2;
  if (HAL_ADC_ConfigChannel(&hadc1, &sConfig) != HAL_OK)
  {
    Error_Handler();
  }
  /** Configure for the selected ADC regular channel its corresponding rank in the sequencer and its sample time. 
  */
  sConfig.Channel = ADC_CHANNEL_7;
  sConfig.Rank = 3;
  if (HAL_ADC_ConfigChannel(&hadc1, &sConfig) != HAL_OK)
  {
    Error_Handler();
  }
  /** Configure for the selected ADC regular channel its corresponding rank in the sequencer and its sample time. 
  */
  sConfig.Channel = ADC_CHANNEL_8;
  sConfig.Rank = 4;
  if (HAL_ADC_ConfigChannel(&hadc1, &sConfig) != HAL_OK)
  {
    Error_Handler();
  }
  /** Configure for the selected ADC regular channel its corresponding rank in the sequencer and its sample time. 
  */
  sConfig.Channel = ADC_CHANNEL_9;
  sConfig.Rank = 5;
  if (HAL_ADC_ConfigChannel(&hadc1, &sConfig) != HAL_OK)
  {
    Error_Handler();
  }
  /** Configure for the selected ADC regular channel its corresponding rank in the sequencer and its sample time. 
  */
  sConfig.Channel = ADC_CHANNEL_10;
  sConfig.Rank = 6;
  if (HAL_ADC_ConfigChannel(&hadc1, &sConfig) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN ADC1_Init 2 */

  /* USER CODE END ADC1_Init 2 */

}

/**
  * @brief DAC Initialization Function
  * @param None
  * @retval None
  */
static void MX_DAC_Init(void)
{

  /* USER CODE BEGIN DAC_Init 0 */

  /* USER CODE END DAC_Init 0 */

  DAC_ChannelConfTypeDef sConfig = {0};

  /* USER CODE BEGIN DAC_Init 1 */

  /* USER CODE END DAC_Init 1 */
  /** DAC Initialization 
  */
  hdac.Instance = DAC;
  if (HAL_DAC_Init(&hdac) != HAL_OK)
  {
    Error_Handler();
  }
  /** DAC channel OUT1 config 
  */
  sConfig.DAC_Trigger = DAC_TRIGGER_NONE;
  sConfig.DAC_OutputBuffer = DAC_OUTPUTBUFFER_ENABLE;
  if (HAL_DAC_ConfigChannel(&hdac, &sConfig, DAC_CHANNEL_1) != HAL_OK)
  {
    Error_Handler();
  }
  /** DAC channel OUT2 config 
  */
  if (HAL_DAC_ConfigChannel(&hdac, &sConfig, DAC_CHANNEL_2) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN DAC_Init 2 */

  /* USER CODE END DAC_Init 2 */

}

/**
  * @brief I2C1 Initialization Function
  * @param None
  * @retval None
  */
static void MX_I2C1_Init(void)
{

  /* USER CODE BEGIN I2C1_Init 0 */

  /* USER CODE END I2C1_Init 0 */

  /* USER CODE BEGIN I2C1_Init 1 */

  /* USER CODE END I2C1_Init 1 */
  hi2c1.Instance = I2C1;
  hi2c1.Init.ClockSpeed = 400000;
  hi2c1.Init.DutyCycle = I2C_DUTYCYCLE_2;
  hi2c1.Init.OwnAddress1 = 0;
  hi2c1.Init.AddressingMode = I2C_ADDRESSINGMODE_7BIT;
  hi2c1.Init.DualAddressMode = I2C_DUALADDRESS_DISABLE;
  hi2c1.Init.OwnAddress2 = 0;
  hi2c1.Init.GeneralCallMode = I2C_GENERALCALL_DISABLE;
  hi2c1.Init.NoStretchMode = I2C_NOSTRETCH_DISABLE;
  if (HAL_I2C_Init(&hi2c1) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN I2C1_Init 2 */

  /* USER CODE END I2C1_Init 2 */

}

/**
  * @brief I2C2 Initialization Function
  * @param None
  * @retval None
  */
static void MX_I2C2_Init(void)
{

  /* USER CODE BEGIN I2C2_Init 0 */

  /* USER CODE END I2C2_Init 0 */

  /* USER CODE BEGIN I2C2_Init 1 */

  /* USER CODE END I2C2_Init 1 */
  hi2c2.Instance = I2C2;
  hi2c2.Init.ClockSpeed = 400000;
  hi2c2.Init.DutyCycle = I2C_DUTYCYCLE_2;
  hi2c2.Init.OwnAddress1 = 0;
  hi2c2.Init.AddressingMode = I2C_ADDRESSINGMODE_7BIT;
  hi2c2.Init.DualAddressMode = I2C_DUALADDRESS_DISABLE;
  hi2c2.Init.OwnAddress2 = 0;
  hi2c2.Init.GeneralCallMode = I2C_GENERALCALL_DISABLE;
  hi2c2.Init.NoStretchMode = I2C_NOSTRETCH_DISABLE;
  if (HAL_I2C_Init(&hi2c2) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN I2C2_Init 2 */

  /* USER CODE END I2C2_Init 2 */

}

/**
  * @brief I2C3 Initialization Function
  * @param None
  * @retval None
  */
static void MX_I2C3_Init(void)
{

  /* USER CODE BEGIN I2C3_Init 0 */

  /* USER CODE END I2C3_Init 0 */

  /* USER CODE BEGIN I2C3_Init 1 */

  /* USER CODE END I2C3_Init 1 */
  hi2c3.Instance = I2C3;
  hi2c3.Init.ClockSpeed = 400000;
  hi2c3.Init.DutyCycle = I2C_DUTYCYCLE_2;
  hi2c3.Init.OwnAddress1 = 0;
  hi2c3.Init.AddressingMode = I2C_ADDRESSINGMODE_7BIT;
  hi2c3.Init.DualAddressMode = I2C_DUALADDRESS_DISABLE;
  hi2c3.Init.OwnAddress2 = 0;
  hi2c3.Init.GeneralCallMode = I2C_GENERALCALL_DISABLE;
  hi2c3.Init.NoStretchMode = I2C_NOSTRETCH_DISABLE;
  if (HAL_I2C_Init(&hi2c3) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN I2C3_Init 2 */

  /* USER CODE END I2C3_Init 2 */

}

/**
  * @brief TIM1 Initialization Function
  * @param None
  * @retval None
  */
static void MX_TIM1_Init(void)
{

  /* USER CODE BEGIN TIM1_Init 0 */

  /* USER CODE END TIM1_Init 0 */

  TIM_ClockConfigTypeDef sClockSourceConfig = {0};
  TIM_MasterConfigTypeDef sMasterConfig = {0};
  TIM_IC_InitTypeDef sConfigIC = {0};

  /* USER CODE BEGIN TIM1_Init 1 */

  /* USER CODE END TIM1_Init 1 */
  htim1.Instance = TIM1;
  htim1.Init.Prescaler = 127;
  htim1.Init.CounterMode = TIM_COUNTERMODE_UP;
  htim1.Init.Period = 65535;
  htim1.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
  htim1.Init.RepetitionCounter = 0;
  htim1.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_DISABLE;
  if (HAL_TIM_Base_Init(&htim1) != HAL_OK)
  {
    Error_Handler();
  }
  sClockSourceConfig.ClockSource = TIM_CLOCKSOURCE_INTERNAL;
  if (HAL_TIM_ConfigClockSource(&htim1, &sClockSourceConfig) != HAL_OK)
  {
    Error_Handler();
  }
  if (HAL_TIM_IC_Init(&htim1) != HAL_OK)
  {
    Error_Handler();
  }
  sMasterConfig.MasterOutputTrigger = TIM_TRGO_RESET;
  sMasterConfig.MasterSlaveMode = TIM_MASTERSLAVEMODE_DISABLE;
  if (HAL_TIMEx_MasterConfigSynchronization(&htim1, &sMasterConfig) != HAL_OK)
  {
    Error_Handler();
  }
  sConfigIC.ICPolarity = TIM_INPUTCHANNELPOLARITY_RISING;
  sConfigIC.ICSelection = TIM_ICSELECTION_DIRECTTI;
  sConfigIC.ICPrescaler = TIM_ICPSC_DIV1;
  sConfigIC.ICFilter = 0;
  if (HAL_TIM_IC_ConfigChannel(&htim1, &sConfigIC, TIM_CHANNEL_1) != HAL_OK)
  {
    Error_Handler();
  }
  sConfigIC.ICPolarity = TIM_INPUTCHANNELPOLARITY_FALLING;
  sConfigIC.ICSelection = TIM_ICSELECTION_INDIRECTTI;
  if (HAL_TIM_IC_ConfigChannel(&htim1, &sConfigIC, TIM_CHANNEL_2) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN TIM1_Init 2 */

  /* USER CODE END TIM1_Init 2 */

}

/**
  * @brief TIM3 Initialization Function
  * @param None
  * @retval None
  */
static void MX_TIM3_Init(void)
{

  /* USER CODE BEGIN TIM3_Init 0 */

  /* USER CODE END TIM3_Init 0 */

  TIM_ClockConfigTypeDef sClockSourceConfig = {0};
  TIM_MasterConfigTypeDef sMasterConfig = {0};
  TIM_OC_InitTypeDef sConfigOC = {0};

  /* USER CODE BEGIN TIM3_Init 1 */

  /* USER CODE END TIM3_Init 1 */
  htim3.Instance = TIM3;
  htim3.Init.Prescaler = 31;
  htim3.Init.CounterMode = TIM_COUNTERMODE_UP;
  htim3.Init.Period = 5249;
  htim3.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
  htim3.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_DISABLE;
  if (HAL_TIM_Base_Init(&htim3) != HAL_OK)
  {
    Error_Handler();
  }
  sClockSourceConfig.ClockSource = TIM_CLOCKSOURCE_INTERNAL;
  if (HAL_TIM_ConfigClockSource(&htim3, &sClockSourceConfig) != HAL_OK)
  {
    Error_Handler();
  }
  if (HAL_TIM_OC_Init(&htim3) != HAL_OK)
  {
    Error_Handler();
  }
  sMasterConfig.MasterOutputTrigger = TIM_TRGO_OC1REF;
  sMasterConfig.MasterSlaveMode = TIM_MASTERSLAVEMODE_DISABLE;
  if (HAL_TIMEx_MasterConfigSynchronization(&htim3, &sMasterConfig) != HAL_OK)
  {
    Error_Handler();
  }
  sConfigOC.OCMode = TIM_OCMODE_TOGGLE;
  sConfigOC.Pulse = 0;
  sConfigOC.OCPolarity = TIM_OCPOLARITY_HIGH;
  sConfigOC.OCFastMode = TIM_OCFAST_DISABLE;
  if (HAL_TIM_OC_ConfigChannel(&htim3, &sConfigOC, TIM_CHANNEL_1) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN TIM3_Init 2 */

  /* USER CODE END TIM3_Init 2 */

}

/**
  * @brief TIM4 Initialization Function
  * @param None
  * @retval None
  */
static void MX_TIM4_Init(void)
{

  /* USER CODE BEGIN TIM4_Init 0 */

  /* USER CODE END TIM4_Init 0 */

  TIM_ClockConfigTypeDef sClockSourceConfig = {0};
  TIM_MasterConfigTypeDef sMasterConfig = {0};
  TIM_OC_InitTypeDef sConfigOC = {0};

  /* USER CODE BEGIN TIM4_Init 1 */

  /* USER CODE END TIM4_Init 1 */
  htim4.Instance = TIM4;
  htim4.Init.Prescaler = 99;
  htim4.Init.CounterMode = TIM_COUNTERMODE_UP;
  htim4.Init.Period = 8399;
  htim4.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
  htim4.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_DISABLE;
  if (HAL_TIM_Base_Init(&htim4) != HAL_OK)
  {
    Error_Handler();
  }
  sClockSourceConfig.ClockSource = TIM_CLOCKSOURCE_INTERNAL;
  if (HAL_TIM_ConfigClockSource(&htim4, &sClockSourceConfig) != HAL_OK)
  {
    Error_Handler();
  }
  if (HAL_TIM_PWM_Init(&htim4) != HAL_OK)
  {
    Error_Handler();
  }
  sMasterConfig.MasterOutputTrigger = TIM_TRGO_RESET;
  sMasterConfig.MasterSlaveMode = TIM_MASTERSLAVEMODE_DISABLE;
  if (HAL_TIMEx_MasterConfigSynchronization(&htim4, &sMasterConfig) != HAL_OK)
  {
    Error_Handler();
  }
  sConfigOC.OCMode = TIM_OCMODE_PWM1;
  sConfigOC.Pulse = 0;
  sConfigOC.OCPolarity = TIM_OCPOLARITY_HIGH;
  sConfigOC.OCFastMode = TIM_OCFAST_DISABLE;
  if (HAL_TIM_PWM_ConfigChannel(&htim4, &sConfigOC, TIM_CHANNEL_1) != HAL_OK)
  {
    Error_Handler();
  }
  if (HAL_TIM_PWM_ConfigChannel(&htim4, &sConfigOC, TIM_CHANNEL_2) != HAL_OK)
  {
    Error_Handler();
  }
  if (HAL_TIM_PWM_ConfigChannel(&htim4, &sConfigOC, TIM_CHANNEL_3) != HAL_OK)
  {
    Error_Handler();
  }
  if (HAL_TIM_PWM_ConfigChannel(&htim4, &sConfigOC, TIM_CHANNEL_4) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN TIM4_Init 2 */

  /* USER CODE END TIM4_Init 2 */
  HAL_TIM_MspPostInit(&htim4);

}

/**
  * @brief TIM9 Initialization Function
  * @param None
  * @retval None
  */
static void MX_TIM9_Init(void)
{

  /* USER CODE BEGIN TIM9_Init 0 */

  /* USER CODE END TIM9_Init 0 */

  TIM_ClockConfigTypeDef sClockSourceConfig = {0};
  TIM_IC_InitTypeDef sConfigIC = {0};

  /* USER CODE BEGIN TIM9_Init 1 */

  /* USER CODE END TIM9_Init 1 */
  htim9.Instance = TIM9;
  htim9.Init.Prescaler = 127;
  htim9.Init.CounterMode = TIM_COUNTERMODE_UP;
  htim9.Init.Period = 65535;
  htim9.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
  htim9.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_DISABLE;
  if (HAL_TIM_Base_Init(&htim9) != HAL_OK)
  {
    Error_Handler();
  }
  sClockSourceConfig.ClockSource = TIM_CLOCKSOURCE_INTERNAL;
  if (HAL_TIM_ConfigClockSource(&htim9, &sClockSourceConfig) != HAL_OK)
  {
    Error_Handler();
  }
  if (HAL_TIM_IC_Init(&htim9) != HAL_OK)
  {
    Error_Handler();
  }
  sConfigIC.ICPolarity = TIM_INPUTCHANNELPOLARITY_RISING;
  sConfigIC.ICSelection = TIM_ICSELECTION_DIRECTTI;
  sConfigIC.ICPrescaler = TIM_ICPSC_DIV1;
  sConfigIC.ICFilter = 0;
  if (HAL_TIM_IC_ConfigChannel(&htim9, &sConfigIC, TIM_CHANNEL_1) != HAL_OK)
  {
    Error_Handler();
  }
  sConfigIC.ICPolarity = TIM_INPUTCHANNELPOLARITY_FALLING;
  sConfigIC.ICSelection = TIM_ICSELECTION_INDIRECTTI;
  if (HAL_TIM_IC_ConfigChannel(&htim9, &sConfigIC, TIM_CHANNEL_2) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN TIM9_Init 2 */

  /* USER CODE END TIM9_Init 2 */

}

/**
  * @brief TIM12 Initialization Function
  * @param None
  * @retval None
  */
static void MX_TIM12_Init(void)
{

  /* USER CODE BEGIN TIM12_Init 0 */

  /* USER CODE END TIM12_Init 0 */

  TIM_ClockConfigTypeDef sClockSourceConfig = {0};
  TIM_IC_InitTypeDef sConfigIC = {0};

  /* USER CODE BEGIN TIM12_Init 1 */

  /* USER CODE END TIM12_Init 1 */
  htim12.Instance = TIM12;
  htim12.Init.Prescaler = 127;
  htim12.Init.CounterMode = TIM_COUNTERMODE_UP;
  htim12.Init.Period = 65535;
  htim12.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
  htim12.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_DISABLE;
  if (HAL_TIM_Base_Init(&htim12) != HAL_OK)
  {
    Error_Handler();
  }
  sClockSourceConfig.ClockSource = TIM_CLOCKSOURCE_INTERNAL;
  if (HAL_TIM_ConfigClockSource(&htim12, &sClockSourceConfig) != HAL_OK)
  {
    Error_Handler();
  }
  if (HAL_TIM_IC_Init(&htim12) != HAL_OK)
  {
    Error_Handler();
  }
  sConfigIC.ICPolarity = TIM_INPUTCHANNELPOLARITY_RISING;
  sConfigIC.ICSelection = TIM_ICSELECTION_DIRECTTI;
  sConfigIC.ICPrescaler = TIM_ICPSC_DIV1;
  sConfigIC.ICFilter = 0;
  if (HAL_TIM_IC_ConfigChannel(&htim12, &sConfigIC, TIM_CHANNEL_1) != HAL_OK)
  {
    Error_Handler();
  }
  sConfigIC.ICPolarity = TIM_INPUTCHANNELPOLARITY_FALLING;
  sConfigIC.ICSelection = TIM_ICSELECTION_INDIRECTTI;
  if (HAL_TIM_IC_ConfigChannel(&htim12, &sConfigIC, TIM_CHANNEL_2) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN TIM12_Init 2 */

  /* USER CODE END TIM12_Init 2 */

}

/**
  * @brief USART3 Initialization Function
  * @param None
  * @retval None
  */
static void MX_USART3_UART_Init(void)
{

  /* USER CODE BEGIN USART3_Init 0 */

  /* USER CODE END USART3_Init 0 */

  /* USER CODE BEGIN USART3_Init 1 */

  /* USER CODE END USART3_Init 1 */
  huart3.Instance = USART3;
  huart3.Init.BaudRate = 115200;
  huart3.Init.WordLength = UART_WORDLENGTH_8B;
  huart3.Init.StopBits = UART_STOPBITS_1;
  huart3.Init.Parity = UART_PARITY_NONE;
  huart3.Init.Mode = UART_MODE_TX_RX;
  huart3.Init.HwFlowCtl = UART_HWCONTROL_NONE;
  huart3.Init.OverSampling = UART_OVERSAMPLING_16;
  if (HAL_UART_Init(&huart3) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN USART3_Init 2 */

  /* USER CODE END USART3_Init 2 */

}

/** 
  * Enable DMA controller clock
  */
static void MX_DMA_Init(void) 
{
  /* DMA controller clock enable */
  __HAL_RCC_DMA2_CLK_ENABLE();

  /* DMA interrupt init */
  /* DMA2_Stream0_IRQn interrupt configuration */
  HAL_NVIC_SetPriority(DMA2_Stream0_IRQn, 0, 0);
  HAL_NVIC_EnableIRQ(DMA2_Stream0_IRQn);

}

/**
  * @brief GPIO Initialization Function
  * @param None
  * @retval None
  */
static void MX_GPIO_Init(void)
{
  GPIO_InitTypeDef GPIO_InitStruct = {0};

  /* GPIO Ports Clock Enable */
  __HAL_RCC_GPIOE_CLK_ENABLE();
  __HAL_RCC_GPIOH_CLK_ENABLE();
  __HAL_RCC_GPIOC_CLK_ENABLE();
  __HAL_RCC_GPIOA_CLK_ENABLE();
  __HAL_RCC_GPIOB_CLK_ENABLE();
  __HAL_RCC_GPIOD_CLK_ENABLE();

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(GPIOB, GPIO_PIN_12|GPIO_PIN_13, GPIO_PIN_RESET);

  /*Configure GPIO pin : PA0 */
  GPIO_InitStruct.Pin = GPIO_PIN_0;
  GPIO_InitStruct.Mode = GPIO_MODE_INPUT;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /*Configure GPIO pins : PB12 PB13 */
  GPIO_InitStruct.Pin = GPIO_PIN_12|GPIO_PIN_13;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_PULLUP;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);

}

/* USER CODE BEGIN 4 */
void MPU9250_I2C_WriteData(uint16_t aaddress, uint8_t aregister, uint8_t adata)
{
  uint8_t TxBuffer[2];
  TxBuffer[0] = aregister;
  TxBuffer[1] = adata;
  while(HAL_I2C_Master_Transmit(&hi2c1, aaddress << 1, (uint8_t*)TxBuffer, 2, 1000) != HAL_OK);
}
uint8_t MPU9250_I2C_ReadData(uint16_t aaddress, uint8_t aregister)
{
  uint8_t TxBuffer[2];
  uint8_t RxBuffer[2];
  TxBuffer[0] = aregister;
  while(HAL_I2C_Master_Transmit(&hi2c1, aaddress << 1, (uint8_t*)TxBuffer, 1, 1000) != HAL_OK);
  while(HAL_I2C_Master_Receive(&hi2c1,  aaddress << 1, (uint8_t*)RxBuffer, 1, 1000) != HAL_OK);
  return RxBuffer[0];
}
void MPU9250_I2C_ReadDataBurst14(uint16_t aaddress, uint8_t aregister, uint8_t RxBuffer[14])
{
  uint8_t TxBuffer[2];
  TxBuffer[0] = aregister;
  while(HAL_I2C_Master_Transmit(&hi2c1, aaddress << 1, (uint8_t*)TxBuffer, 1, 1000) != HAL_OK);
  while(HAL_I2C_Master_Receive(&hi2c1,  aaddress << 1, (uint8_t*)RxBuffer, 14, 1000) != HAL_OK);
}
void MPU9250_I2C_ReadDataBurst6(uint16_t aaddress, uint8_t aregister, uint8_t RxBuffer[6])
{
  uint8_t TxBuffer[2];
  TxBuffer[0] = aregister;
  while(HAL_I2C_Master_Transmit(&hi2c1, aaddress << 1, (uint8_t*)TxBuffer, 1, 1000) != HAL_OK);
  while(HAL_I2C_Master_Receive(&hi2c1,  aaddress << 1, (uint8_t*)RxBuffer, 6, 1000) != HAL_OK);
}
int fputc(int ch, FILE *f)
{
  HAL_Status = HAL_UART_Transmit(&huart3, (uint8_t*)&ch, 1, 200);
  return ch;
}
int fgetc(FILE *f)
{
  uint8_t TempByte;
  HAL_Status = HAL_UART_Receive(&huart3, (uint8_t*)&TempByte, 1, 200);
  return TempByte;
}
float32_t LAG(float32_t xn, float32_t ts, float32_t tau, float32_t *xn_1, float32_t *yn_1)
{
  float32_t Two = 2.0;
  float32_t a = ts;
  float32_t b = ts;
  float32_t c = Two * tau + ts;
  float32_t d = -Two * tau + ts;
  float32_t yn = 0.0;
  yn = (-(*yn_1)*d + xn*a + (*xn_1)*b)/c;
  *xn_1 = xn;
  *yn_1 = yn;
  return yn;
}
float32_t INTEGRATE(float32_t xn, float32_t ts, float32_t upper, float32_t lower, float32_t *xn_1, float32_t *yn_1)
{
  float32_t Two = 2.0;
  float32_t a = ts/Two;
  float32_t yn = 0.0;
  yn = *yn_1 + a*(xn + *xn_1);
  if(yn >= upper) yn = upper;
  if(yn <= lower) yn = lower;
  *xn_1 = xn;
  *yn_1 = yn;
  return yn;
}
float32_t HIPASS(float32_t xn, float32_t ts, float32_t tau, float32_t *xn_1, float32_t *yn_1)
{
  float32_t One = 1.0;
  float32_t result = 0.0;
  float32_t a = 0.0;
  
  a = LAG(xn, ts, tau, xn_1, yn_1);
  result = One - a;
  return result;
}
void AT24C256_I2C_WriteData(uint16_t aaddress, uint8_t aregister1, uint8_t aregister2, uint8_t adata)
{
  uint8_t TxBuffer[3];
  TxBuffer[0] = aregister1;
  TxBuffer[1] = aregister2;
  TxBuffer[2] = adata;
  while(HAL_I2C_Master_Transmit(&hi2c2, aaddress << 1, (uint8_t*)TxBuffer, 3, 1000) != HAL_OK);
}
uint8_t AT24C256_I2C_ReadData(uint16_t aaddress, uint8_t aregister1, uint8_t aregister2)
{
  uint8_t TxBuffer[2];
  uint8_t RxBuffer[2];
  TxBuffer[0] = aregister1;
  TxBuffer[1] = aregister2;
  while(HAL_I2C_Master_Transmit(&hi2c2, aaddress << 1, (uint8_t*)TxBuffer, 2, 1000) != HAL_OK);
  while(HAL_I2C_Master_Receive(&hi2c2,  aaddress << 1, (uint8_t*)RxBuffer, 1, 1000) != HAL_OK);
  return RxBuffer[0];
}
void RFD77402_I2C_WriteData(uint16_t aaddress, uint8_t aregister, uint8_t adata)
{
  uint8_t TxBuffer[2];
  TxBuffer[0] = aregister;
  TxBuffer[1] = adata;
  while(HAL_I2C_Master_Transmit(&hi2c3, aaddress << 1, (uint8_t*)TxBuffer, 2, 1000) != HAL_OK);
}
uint8_t RFD77402_I2C_ReadData(uint16_t aaddress, uint8_t aregister)
{
  uint8_t TxBuffer[2];
  uint8_t RxBuffer[2];
  TxBuffer[0] = aregister;
  while(HAL_I2C_Master_Transmit(&hi2c3, aaddress << 1, (uint8_t*)TxBuffer, 1, 1000) != HAL_OK);
  while(HAL_I2C_Master_Receive(&hi2c3,  aaddress << 1, (uint8_t*)RxBuffer, 1, 1000) != HAL_OK);
  return RxBuffer[0];
}
/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */

  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{ 
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     tex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
