; EXAMP03.ASM - P1 - Binary Counter
; Started 06/06/2022
; Uses led_driver_00 connected to the P1 port.
; This will illuminate the eight LEDs to show the binary counter.
; A countdown timer is used to add some delay between each count.
;
$MOD51
$TITLE(EXAMP03.ASM)
$DATE(JUN-06-22)
$PAGEWIDTH(132)
$OBJECT(EXAMP03.HEX);
;
CDTIM1   EQU  0FFH        ; Countdown Timer 1 Initial Value for delay. 
                          ; 0xFF is the maximum value.
;
         ORG  0800H       ; The user external rom starts at 0x0800.
         MOV  R1,#000H    ; Initialize R1 to zero.         
LABEL1:  MOV  P1,R1       ; Set P1 to R1. 
         MOV  A,#CDTIM1   ; Initilize the countdown timer.
LABEL2:  JZ   LABEL3      ; If A is zero then increment the binary counter R1.
         DEC  A		      ; Decrement the countdown timer.
         SJMP LABEL2      ; Loop to continue decrementing the timer.
LABEL3:  INC  R1          ; Increment the binary counter in R1.
         SJMP LABEL1      ; Repeat the loop.		 
         END