-- sig02
-- Started 05/13/2022
-- This is a signal pulse generator.

-- VHDL library Declarations
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;

-- The Entity Declarations
ENTITY sig02 IS
	PORT
	(
		-- rst & clk
		reset_0:				IN STD_LOGIC;
		clk:					IN STD_LOGIC;	-- 50 MHz
		
		-- Outputs for the signal generator.
		freq_10000_hz_output:	OUT STD_LOGIC;	-- 10000 Hz clock - 50% duty cycle
		freq_1000_hz_output:	OUT STD_LOGIC;	-- 1000 Hz clock - 50% duty cycle
		freq_100_hz_output:		OUT STD_LOGIC;	-- 100 Hz clock - 50% duty cycle
		freq_10_hz_output:		OUT STD_LOGIC;	-- 10 Hz clock - 50% duty cycle
		freq_1_hz_output:		OUT STD_LOGIC;	-- 1 Hz clock - 50% duty cycle
		freq_p1_hz_output:		OUT STD_LOGIC;	-- 0.1 Hz clock - 50% duty cycle
		led01:					OUT STD_LOGIC;	-- LED01 - 100 Hz flasher
		led02:					OUT STD_LOGIC;	-- LED02 - 10 Hz flasher
		led03:					OUT STD_LOGIC;	-- LED03 - 1 Hz flasher
		led04:					OUT STD_LOGIC);-- LED04 - 0.1 Hz flasher
END sig02;

-- The Architecture of Entity Declarations
ARCHITECTURE Behavioral OF sig02 IS
	SIGNAL freq_10000_hz:		STD_LOGIC:='0'; -- 10000 Hz - pulse
	SIGNAL freq_1000_hz:		STD_LOGIC:='0'; -- 1000 Hz - pulse
	SIGNAL freq_100_hz:			STD_LOGIC:='0'; -- 100 Hz - pulse	
	SIGNAL freq_10_hz:			STD_LOGIC:='0'; -- 10 Hz - pulse
	SIGNAL freq_1_hz:			STD_LOGIC:='0'; -- 1 Hz - pulse
	SIGNAL counter_10000_hz: 	INTEGER:=4999; -- Countdown
	SIGNAL counter_1000_hz: 	INTEGER:=9; -- Countdown
	SIGNAL counter_100_hz: 		INTEGER:=9; -- Countdown
	SIGNAL counter_10_hz: 		INTEGER:=9; -- Countdown
	SIGNAL counter_1_hz:		INTEGER:=9; -- Countdown
	SIGNAL counter_p1_hz: 		INTEGER:=9; -- Countdown
	SIGNAL freq_10000_hz_dc: 	STD_LOGIC:='0'; -- 10000 Hz - pulse 50% Duty Cycle
	SIGNAL freq_1000_hz_dc: 	STD_LOGIC:='0'; -- 1000 Hz - pulse 50% Duty Cycle
	SIGNAL freq_100_hz_dc: 		STD_LOGIC:='0'; -- 100 Hz - pulse 50% Duty Cycle
	SIGNAL freq_10_hz_dc: 		STD_LOGIC:='0'; -- 10 Hz - pulse 50% Duty Cycle
	SIGNAL freq_1_hz_dc: 		STD_LOGIC:='0'; -- 1 Hz - pulse 50% Duty Cycle
	SIGNAL freq_p1_hz_dc: 		STD_LOGIC:='0'; -- 0.1 Hz - pulse 50% Duty Cycle
BEGIN

-- Service the leds
PROCESS(reset_0,clk)
BEGIN
	IF reset_0 = '0' THEN
	led01 <= '1';
	led02 <= '1';
	led03 <= '1';
	led04 <= '1';
	ELSIF RISING_EDGE(clk) THEN
		IF freq_100_hz_dc = '1' THEN
			led01 <= '0';
		ELSE
			led01 <= '1';
		END IF;	
		IF freq_10_hz_dc = '1' THEN
			led02 <= '0';
		ELSE
			led02 <= '1';
		END IF;
		IF freq_1_hz_dc = '1' THEN
			led03 <= '0';
		ELSE
			led03 <= '1';
		END IF;		
		IF freq_p1_hz_dc = '1' THEN
			led04 <= '0';
		ELSE
			led04 <= '1';
		END IF;	
	END IF;
END PROCESS;

-- 10000 Hz signal generator
PROCESS(reset_0,clk)
BEGIN
	IF reset_0 = '0' THEN
		counter_10000_hz <= 4999;
		freq_10000_hz <= '0';
		freq_10000_hz_dc <= '0';
	ELSIF RISING_EDGE(clk) THEN
		IF counter_10000_hz /=0 THEN
			counter_10000_hz <= counter_10000_hz - 1;
		ELSE
			counter_10000_hz <= 4999;
		END IF;
		IF counter_10000_hz = 0 THEN
			freq_10000_hz <= '1';
		ELSE
			freq_10000_hz <= '0';
		END IF;
		IF counter_10000_hz < 2500 THEN
			freq_10000_hz_dc <= '1';
		ELSE
			freq_10000_hz_dc <= '0';
		END IF;
	END IF;
END PROCESS;

freq_10000_hz_output <= freq_10000_hz_dc;

-- 1000 Hz signal generator
PROCESS(reset_0,freq_10000_hz)
BEGIN
	IF reset_0 = '0' THEN
		counter_1000_hz <= 9;
		freq_1000_hz <= '0';
		freq_1000_hz_dc <= '0';
	ELSIF RISING_EDGE(freq_10000_hz) THEN
		IF counter_1000_hz /=0 THEN
			counter_1000_hz <= counter_1000_hz - 1;
		ELSE
			counter_1000_hz <= 9;
		END IF;
		IF counter_1000_hz = 0 THEN
			freq_1000_hz <= '1';
		ELSE
			freq_1000_hz <= '0';
		END IF;
		IF counter_1000_hz < 5 THEN
			freq_1000_hz_dc <= '1';
		ELSE
			freq_1000_hz_dc <= '0';
		END IF;	
	END IF;
END PROCESS;

freq_1000_hz_output <= freq_1000_hz_dc;

-- 100 Hz signal generator
PROCESS(reset_0,freq_1000_hz)
BEGIN
	IF reset_0 = '0' THEN
		counter_100_hz <= 9;
		freq_100_hz <= '0';
		freq_100_hz_dc <= '0';
	ELSIF RISING_EDGE(freq_1000_hz) THEN
		IF counter_100_hz /=0 THEN
			counter_100_hz <= counter_100_hz - 1;
		ELSE
			counter_100_hz <= 9;
		END IF;
		IF counter_100_hz = 0 THEN
			freq_100_hz <= '1';
		ELSE
			freq_100_hz <= '0';
		END IF;
		IF counter_100_hz < 5 THEN
			freq_100_hz_dc <= '1';
		ELSE
			freq_100_hz_dc <= '0';
		END IF;	
	END IF;
END PROCESS;

freq_100_hz_output <= freq_100_hz_dc;

-- 10 Hz signal generator
PROCESS(reset_0,freq_100_hz)
BEGIN
	IF reset_0 = '0' THEN
		counter_10_hz <= 9;
		freq_10_hz <= '0';
		freq_10_hz_dc <= '0';
	ELSIF RISING_EDGE(freq_100_hz) THEN
		IF counter_10_hz /=0 THEN
			counter_10_hz <= counter_10_hz - 1;
		ELSE
			counter_10_hz <= 9;
		END IF;
		IF counter_10_hz = 0 THEN
			freq_10_hz <= '1';
		ELSE
			freq_10_hz <= '0';
		END IF;
		IF counter_10_hz < 5 THEN
			freq_10_hz_dc <= '1';
		ELSE
			freq_10_hz_dc <= '0';
		END IF;	
	END IF;
END PROCESS;

freq_10_hz_output <= freq_10_hz_dc;

-- 1 Hz signal generator
PROCESS(reset_0,freq_10_hz)
BEGIN
	IF reset_0 = '0' THEN
		counter_1_hz <= 9;
		freq_1_hz <= '0';
		freq_1_hz_dc <= '0';
	ELSIF RISING_EDGE(freq_10_hz) THEN
		IF counter_1_hz /=0 THEN
			counter_1_hz <= counter_1_hz - 1;
		ELSE
			counter_1_hz <= 9;
		END IF;
		IF counter_1_hz = 0 THEN
			freq_1_hz <= '1';
		ELSE
			freq_1_hz <= '0';
		END IF;
		IF counter_1_hz < 5 THEN
			freq_1_hz_dc <= '1';
		ELSE
			freq_1_hz_dc <= '0';
		END IF;	
	END IF;
END PROCESS;

freq_1_hz_output <= freq_1_hz_dc;

-- 0.1 Hz signal generator
PROCESS(reset_0,freq_1_hz)
BEGIN
	IF reset_0 = '0' THEN
		counter_p1_hz <= 9;
		freq_p1_hz_dc <= '0';
	ELSIF RISING_EDGE(freq_1_hz) THEN
		IF counter_p1_hz /=0 THEN
			counter_p1_hz <= counter_p1_hz - 1;
		ELSE
			counter_p1_hz <= 9;
		END IF;
		IF counter_p1_hz < 5 THEN
			freq_p1_hz_dc <= '1';
		ELSE
			freq_p1_hz_dc <= '0';
		END IF;	
	END IF;
END PROCESS;

freq_p1_hz_output <= freq_p1_hz_dc;
	
END Behavioral;